/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.ut.assertor;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import io.nuun.kernel.tests.internal.ElementMap;
import io.nuun.kernel.tests.internal.visitor.MapElementVisitor;
import io.nuun.kernel.tests.ut.assertor.ElementAssertor;
import io.nuun.kernel.tests.ut.assertor.ElementDelta;
import io.nuun.kernel.tests.ut.assertor.ModuleAssertor;
import java.util.Collection;

public class ModuleDiff {
    private final Module actual;
    private final ElementMap<ElementAssertor> assertions;

    public ModuleDiff(Module actual, ModuleAssertor moduleAssertor) {
        this.actual = actual;
        this.assertions = moduleAssertor.assertions();
    }

    public ElementMap<ElementDelta> diff() {
        ElementMap<ElementDelta> delta = new ElementMap<ElementDelta>();
        ElementMap<Element> actualStore = this.visit(this.actual);
        for (Class keyClass : this.assertions.keys()) {
            Collection actualInstances = actualStore.get(keyClass);
            Collection elementAssertors = this.assertions.get(keyClass);
            if (actualInstances == null || elementAssertors == null) continue;
            for (final ElementAssertor elementAssertor : elementAssertors) {
                int count = Collections2.filter((Collection)actualInstances, (Predicate)new Predicate<Element>(){

                    public boolean apply(Element input) {
                        return elementAssertor.asserts(input);
                    }
                }).size();
                if (count == elementAssertor.expectedTimes()) continue;
                delta.put(keyClass, new ElementDelta(elementAssertor, count));
            }
        }
        return delta;
    }

    private ElementMap<Element> visit(Module candidate) {
        ElementMap<Element> elementMap = null;
        MapElementVisitor visitor = new MapElementVisitor();
        for (Element element : Elements.getElements((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{candidate})) {
            element.acceptVisitor((ElementVisitor)visitor);
        }
        elementMap = visitor.getStore();
        return elementMap;
    }
}

