/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.internal.visitor;

import com.google.inject.Binding;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DisableCircularProxiesOption;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InterceptorBinding;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.Message;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProvisionListenerBinding;
import com.google.inject.spi.RequireAtInjectOnConstructorsOption;
import com.google.inject.spi.RequireExplicitBindingsOption;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListenerBinding;
import io.nuun.kernel.tests.internal.ElementMap;
import io.nuun.kernel.tests.internal.visitor.MapBindingTargetVisitor;

public class MapElementVisitor
implements ElementVisitor<Void> {
    private final ElementMap<Element> elementMap = new ElementMap();
    private final MapBindingTargetVisitor mapBindingTargetVisitor = new MapBindingTargetVisitor(this.elementMap);

    public <T> Void visit(Binding<T> binding) {
        this.log("Bindings found " + binding.getKey().getTypeLiteral().getRawType());
        binding.acceptTargetVisitor((BindingTargetVisitor)this.mapBindingTargetVisitor);
        return null;
    }

    public Void visit(InterceptorBinding binding) {
        this.elementMap.put(InterceptorBinding.class, binding);
        this.log(binding);
        return null;
    }

    public Void visit(ScopeBinding binding) {
        this.elementMap.put(ScopeBinding.class, binding);
        this.log(binding);
        return null;
    }

    public Void visit(TypeConverterBinding binding) {
        this.elementMap.put(TypeConverterBinding.class, binding);
        this.log(binding);
        return null;
    }

    public Void visit(InjectionRequest<?> request) {
        this.elementMap.put(InjectionRequest.class, request);
        this.log(request);
        return null;
    }

    public Void visit(StaticInjectionRequest request) {
        this.elementMap.put(StaticInjectionRequest.class, request);
        this.log(request);
        return null;
    }

    public <T> Void visit(ProviderLookup<T> lookup) {
        this.elementMap.put(ProviderLookup.class, lookup);
        this.log(lookup);
        return null;
    }

    public <T> Void visit(MembersInjectorLookup<T> lookup) {
        this.elementMap.put(ProviderLookup.class, lookup);
        this.log(lookup);
        return null;
    }

    public Void visit(Message message) {
        this.elementMap.put(Message.class, message);
        this.log(message);
        return null;
    }

    public Void visit(PrivateElements elements) {
        this.elementMap.put(PrivateElements.class, elements);
        this.log(elements);
        return null;
    }

    public Void visit(TypeListenerBinding binding) {
        this.elementMap.put(TypeListenerBinding.class, binding);
        this.log(binding);
        return null;
    }

    public Void visit(ProvisionListenerBinding binding) {
        this.elementMap.put(ProvisionListenerBinding.class, binding);
        this.log(binding);
        return null;
    }

    public Void visit(RequireExplicitBindingsOption option) {
        this.elementMap.put(RequireExplicitBindingsOption.class, option);
        this.log(option);
        return null;
    }

    public Void visit(DisableCircularProxiesOption option) {
        this.elementMap.put(DisableCircularProxiesOption.class, option);
        this.log(option);
        return null;
    }

    public Void visit(RequireAtInjectOnConstructorsOption option) {
        this.elementMap.put(RequireAtInjectOnConstructorsOption.class, option);
        this.log(option);
        return null;
    }

    public ElementMap<Element> getStore() {
        return this.elementMap;
    }

    private void log(Object element) {
        System.out.println("------------");
        System.out.println("e : " + element);
    }
}

