/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.internal.dsl;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.api.config.KernelConfiguration;
import io.nuun.kernel.api.di.ModuleValidation;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.core.NuunCore;
import io.nuun.kernel.core.internal.KernelCore;
import io.nuun.kernel.core.internal.scanner.inmemory.ClasspathBuilder;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryMultiThreadClasspath;
import io.nuun.kernel.tests.internal.ElementMap;
import io.nuun.kernel.tests.ut.assertor.ElementDelta;
import io.nuun.kernel.tests.ut.assertor.ModuleAssertor;
import io.nuun.kernel.tests.ut.assertor.ModuleDiff;
import io.nuun.kernel.tests.ut.assertor.dsl.AssertBuilder;
import io.nuun.kernel.tests.ut.fixture.FixtureConfiguration;
import io.nuun.kernel.tests.ut.fixture.ThenBuilder;
import io.nuun.kernel.tests.ut.fixture.WhenBuilder;

public class GivenWhenThenInternal
implements FixtureConfiguration,
WhenBuilder,
ThenBuilder,
WhenBuilder.WhenBuilderMore,
AssertBuilder {
    KernelCore kernel = null;
    private Class<? extends Plugin> pluginClass;
    private ClasspathBuilder classpath;
    private Injector injector;
    private ModuleValidation validation = new ModuleValidation(){

        public boolean canHandle(Class<?> injectionDefinition) {
            return true;
        }

        public void validate(UnitModule unitModule) {
            Module m = (Module)Module.class.cast(unitModule.nativeModule());
            Visitor v = new Visitor();
            for (Element e : Elements.getElements((Module[])new Module[]{m})) {
                e.acceptVisitor((ElementVisitor)v);
            }
        }
    };

    @Override
    public WhenBuilder given(Class<? extends Plugin> pluginClass) {
        this.pluginClass = pluginClass;
        return this;
    }

    @Override
    public WhenBuilder.WhenBuilderMore whenUsing(ClasspathBuilder classpath) {
        this.classpath = classpath;
        this.createAndStartKernel();
        return this;
    }

    @Override
    public WhenBuilder.WhenBuilderMore withLoaded(Class<? extends Plugin> pluginClass) {
        return this;
    }

    @Override
    public WhenBuilder.WhenBuilderMore withLoaded(Plugin plugin) {
        return this;
    }

    @Override
    public AssertBuilder then() {
        return this;
    }

    @Override
    public AssertBuilder assertModule(ModuleAssertor assertor) {
        UnitModule unitModule = this.kernel.unitModule(this.pluginClass);
        assertor.configure();
        ModuleDiff moduleDiff = new ModuleDiff((Module)unitModule.as(Module.class), assertor);
        ElementMap<ElementDelta> diff = moduleDiff.diff();
        System.out.println(assertor.globalHolders().toString());
        if (!diff.isEmpty()) {
            throw new AssertionError((Object)"Oups , \u00e7a marche pas !");
        }
        return this;
    }

    private void createAndStartKernel() {
        this.kernel = (KernelCore)NuunCore.createKernel((KernelConfiguration)NuunCore.newKernelConfiguration().plugins(new Class[]{this.pluginClass}).classpathScanMode(ClasspathScanMode.IN_MEMORY));
        InMemoryMultiThreadClasspath.INSTANCE.reset();
        this.classpath.configure();
        this.kernel.init();
        this.kernel.start();
        this.injector = (Injector)this.kernel.objectGraph().as(Injector.class);
    }

    static class Visitor
    extends DefaultElementVisitor<Void> {
        Visitor() {
        }

        protected Void visitOther(Element element) {
            System.out.println(" => " + element);
            return null;
        }
    }
}

