/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.api.inmemory;

import java.util.regex.Pattern;

public abstract class ClasspathAbstractElement<E> {
    protected final E element;
    private final String name;
    private final String relativePath;

    public ClasspathAbstractElement(E element) {
        this.element = element;
        this.name = this.computeName(this.element);
        this.relativePath = this.computeRelativePath(element);
        this.assertRelativePath(this.relativePath);
    }

    protected void assertRelativePath(String path) {
        if (!Pattern.matches("[a-zA-Z0-9\\-_\\.]+(/[a-zA-Z0-9\\-_\\.]+)*", path)) {
            throw new IllegalArgumentException("\"" + path + "\" must be a valid ressource name : " + "[a-zA-Z0-9\\-_\\.]+(/[a-zA-Z0-9\\-_\\.]+)*");
        }
    }

    protected abstract String computeName(E var1);

    protected abstract String computeRelativePath(E var1);

    public String name() {
        return this.name;
    }

    public String relativePath() {
        return this.relativePath;
    }

    public E internalRepresentation() {
        return this.element;
    }
}

