/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.api.assertions;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AssertUtils {
    public static boolean isInterface(Class<? extends Object> candidate) {
        return candidate.isInterface();
    }

    public static void assertInterface(Class<? extends Object> candidate) {
        AssertUtils.assertionIllegalArgument(AssertUtils.isInterface(candidate), "Type " + candidate + " must be an interface.");
    }

    public static boolean isClass(Class<? extends Object> candidate) {
        return !AssertUtils.isInterface(candidate);
    }

    public static void assertIsClass(Class<? extends Object> candidate) {
        AssertUtils.assertionIllegalArgument(AssertUtils.isClass(candidate), "Type " + candidate + " must not be an interface.");
    }

    public static boolean hasAnnotationDeep(Class<?> memberDeclaringClass, Class<? extends Annotation> candidate) {
        if (memberDeclaringClass.equals(candidate)) {
            return true;
        }
        for (Annotation anno : memberDeclaringClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            if (annoClass.getPackage().getName().startsWith("java.lang") || !AssertUtils.hasAnnotationDeep(annoClass, candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotationDeepRegex(Class<?> memberDeclaringClass, String metaAnnotationRegex) {
        if (memberDeclaringClass.getName().matches(metaAnnotationRegex)) {
            return true;
        }
        for (Annotation anno : memberDeclaringClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            if (annoClass.getPackage().getName().startsWith("java.lang") || !AssertUtils.hasAnnotationDeepRegex(annoClass, metaAnnotationRegex)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEquivalent(Class<? extends Annotation> original, Class<? extends Annotation> copy) {
        for (Method originalMethod : original.getDeclaredMethods()) {
            if (originalMethod.getParameterTypes().length != 0) continue;
            String name = originalMethod.getName();
            try {
                Method cloneMethod = null;
                cloneMethod = copy.getDeclaredMethod(name, new Class[0]);
                if (cloneMethod != null) {
                    if (originalMethod.getReturnType() == cloneMethod.getReturnType()) continue;
                    return false;
                }
                return false;
            }
            catch (SecurityException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return true;
    }

    public static <A extends Annotation> A annotationProxyOf(Class<A> annotationModelType, Annotation annotationClone) {
        return AnnotationCopy.of(annotationModelType, annotationClone);
    }

    public static void assertionIllegalArgument(boolean asserted, String message) {
        if (!asserted) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertionNullPointer(boolean asserted, String message) {
        if (!asserted) {
            throw new NullPointerException(message);
        }
    }

    public static void assertLegal(Object underAssertion, String message) {
        AssertUtils.assertionIllegalArgument(underAssertion != null, message);
    }

    public static void assertNotNull(Object underAssertion, String message) {
        AssertUtils.assertionNullPointer(underAssertion != null, message);
    }

    public static class AnnotationCopy
    implements InvocationHandler {
        private Annotation annotationClone;

        AnnotationCopy(Annotation annotationClone) {
            this.annotationClone = annotationClone;
        }

        public static <A extends Annotation> A of(Class<A> annotationModelType, Annotation annotationClone) {
            return (A)((Annotation)Proxy.newProxyInstance(annotationModelType.getClassLoader(), new Class[]{annotationModelType}, (InvocationHandler)new AnnotationCopy(annotationClone)));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            Method method2 = this.annotationClone.getClass().getMethod(name, new Class[0]);
            return method2.invoke((Object)this.annotationClone, new Object[0]);
        }
    }
}

