/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.inmemory;

import io.nuun.kernel.api.inmemory.ClasspathAbstractElement;
import io.nuun.kernel.api.inmemory.ClasspathClass;
import io.nuun.kernel.api.inmemory.ClasspathResource;
import io.nuun.kernel.api.inmemory.Resource;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryClass;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryMultiThreadClasspath;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryResource;
import java.net.URL;
import java.util.ArrayList;
import org.reflections.vfs.Vfs;

public class InMemoryUrlType
implements Vfs.UrlType {
    public boolean matches(URL url) throws Exception {
        return url != null && url.getProtocol().equalsIgnoreCase("inmemory");
    }

    public Vfs.Dir createDir(URL url) throws Exception {
        String path = url.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return new InMemoryVfsDir(path);
    }

    class InMemoryVfsDir
    implements Vfs.Dir {
        InMemoryMultiThreadClasspath classpath = InMemoryMultiThreadClasspath.INSTANCE;
        private String path;

        public InMemoryVfsDir(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public Iterable<Vfs.File> getFiles() {
            ArrayList<Vfs.File> files = new ArrayList<Vfs.File>();
            for (ClasspathAbstractElement entry : this.classpath.entry(this.path).entries()) {
                if (entry instanceof ClasspathClass) {
                    files.add(new InMemoryClass(((ClasspathClass)entry).getType()));
                }
                if (!(entry instanceof ClasspathResource)) continue;
                files.add(new InMemoryResource((Resource)((ClasspathResource)entry).internalRepresentation()));
            }
            return files;
        }

        public void close() {
        }
    }
}

