/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.inmemory;

import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class InMemoryFactory {
    private static final String INMEMORY = "inmemory";
    private InMemoryHandler handler = new InMemoryHandler();

    public URL createInMemoryClass(Class<?> claSs) throws MalformedURLException {
        return this.url(claSs.getName().replace('.', '/') + ".class");
    }

    public URL createInMemoryResource(String resource) throws MalformedURLException {
        String content = resource.replace('\\', '/');
        return this.url(content);
    }

    private URL url(String content) throws MalformedURLException {
        this.assertElementName(content);
        return new URL((URL)null, "inmemory://localhost/" + content, this.handler);
    }

    protected void assertElementName(String name) {
        if (!Pattern.matches("[a-zA-Z0-9\\-_\\.]+(/[a-zA-Z0-9\\-_\\.]+)*", name)) {
            throw new IllegalArgumentException("\"" + name + "\" must be a valid ressource name : " + "[a-zA-Z0-9\\-_\\.]+(/[a-zA-Z0-9\\-_\\.]+)*");
        }
    }
}

