/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.inmemory;

import io.nuun.kernel.api.inmemory.Classpath;
import io.nuun.kernel.api.inmemory.ClasspathAbstractContainer;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathScannerDisk;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryFactory;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryUrlType;
import io.nuun.kernel.core.internal.scanner.inmemory.MetadataAdapterInMemory;
import java.net.MalformedURLException;
import java.net.URL;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.vfs.Vfs;

public class ClasspathScannerInMemory
extends ClasspathScannerDisk {
    private final Classpath classpath;

    public ClasspathScannerInMemory(Classpath classpath, String ... packageRoot) {
        super(null, packageRoot);
        this.classpath = classpath;
    }

    @Override
    public void doClasspathScan() {
        Scanner[] scanners = this.getScanners();
        ConfigurationBuilder configurationBuilder = this.configurationBuilder().setScanners(scanners);
        configurationBuilder.setMetadataAdapter((MetadataAdapter)new MetadataAdapterInMemory());
        InMemoryFactory factory = new InMemoryFactory();
        for (ClasspathAbstractContainer i : this.classpath.entries()) {
            String name = i.name();
            try {
                configurationBuilder.addUrls(new URL[]{factory.createInMemoryResource(name)});
            }
            catch (MalformedURLException e) {
                throw new KernelException("Malformed URL Exception", e);
            }
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        this.executeScan(reflections, this.classpath);
        for (ClasspathScannerDisk.ScannerCommand command : this.commands) {
            command.execute(reflections);
        }
    }

    private void executeScan(Reflections reflections, Classpath classpath) {
    }

    static {
        Vfs.addDefaultURLTypes((Vfs.UrlType)new InMemoryUrlType());
    }
}

