/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.inmemory;

import io.nuun.kernel.api.inmemory.ClasspathAbstractContainer;
import io.nuun.kernel.api.inmemory.ClasspathAbstractElement;
import io.nuun.kernel.api.inmemory.ClasspathClass;
import io.nuun.kernel.api.inmemory.ClasspathDirectory;
import io.nuun.kernel.api.inmemory.ClasspathJar;
import io.nuun.kernel.api.inmemory.ClasspathResource;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryMultiThreadClasspath;
import java.util.HashMap;
import java.util.Map;

public abstract class ClasspathBuilder {
    private InMemoryMultiThreadClasspath globalClasspath = InMemoryMultiThreadClasspath.INSTANCE;
    private final Map<String, ClasspathAbstractContainer<?>> entries = new HashMap();
    protected ClasspathAbstractContainer<?> currentContainer = null;

    protected void addJar(String name) {
        if (!this.entries.containsKey(name)) {
            this.currentContainer = ClasspathJar.create((String)name);
            this.entries.put(name, this.currentContainer);
            this.globalClasspath.add(this.currentContainer);
        } else {
            this.currentContainer = this.entries.get(name);
        }
    }

    protected void addDirectory(String name) {
        if (!this.entries.containsKey(name)) {
            this.currentContainer = ClasspathDirectory.create((String)name);
            this.entries.put(name, this.currentContainer);
            this.globalClasspath.add(this.currentContainer);
        } else {
            this.currentContainer = this.entries.get(name);
        }
    }

    protected void addResource(String base, String name) {
        if (this.currentContainer == null) {
            throw new IllegalStateException("currentContainer can not be null. please use directory() or jar()");
        }
        this.currentContainer.add((ClasspathAbstractElement)ClasspathResource.res((String)base, (String)name));
    }

    protected void addClass(Class<?> candidate) {
        if (this.currentContainer == null) {
            throw new IllegalStateException("currentContainer can not be null. please use directory() or jar()");
        }
        this.currentContainer.add((ClasspathAbstractElement)new ClasspathClass(candidate));
    }

    public abstract void configure();
}

