/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.disk;

import io.nuun.kernel.api.assertions.AssertUtils;
import java.lang.annotation.Annotation;
import org.reflections.scanners.AbstractScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaAnnotationScanner
extends AbstractScanner {
    Logger logger = LoggerFactory.getLogger(MetaAnnotationScanner.class);
    private final Class<? extends Annotation> annotationType;
    private final String metaAnnotationRegex;

    public MetaAnnotationScanner(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        this.metaAnnotationRegex = null;
    }

    public MetaAnnotationScanner(String metaAnnotationRegex) {
        this.metaAnnotationRegex = metaAnnotationRegex;
        this.annotationType = null;
    }

    public void scan(Object cls) {
        String className = this.getMetadataAdapter().getClassName(cls);
        try {
            Class<?> klass = Class.forName(className);
            if (this.annotationType != null && AssertUtils.hasAnnotationDeep(klass, this.annotationType) && !klass.isAnnotation()) {
                this.getStore().put((Object)this.annotationType.getName(), (Object)className);
            }
            if (this.metaAnnotationRegex != null && AssertUtils.hasAnnotationDeepRegex(klass, (String)this.metaAnnotationRegex) && !klass.isAnnotation()) {
                this.getStore().put((Object)this.metaAnnotationRegex, (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

