/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.disk;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.nuun.kernel.api.assertions.AssertUtils;
import io.nuun.kernel.core.internal.scanner.AbstractClasspathScanner;
import io.nuun.kernel.core.internal.scanner.ClasspathScanner;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathStrategy;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.kametic.specifications.Specification;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.scanners.TypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScannerDisk
extends AbstractClasspathScanner {
    Logger logger = LoggerFactory.getLogger(ClasspathScannerDisk.class);
    private final List<String> packageRoots = new LinkedList<String>();
    private final ClasspathStrategy classpathStrategy;
    private Set<URL> additionalClasspath;
    private Set<URL> urls;
    protected final List<ScannerCommand> commands;

    public ClasspathScannerDisk(ClasspathStrategy classpathStrategy, String ... packageRoots_) {
        this(classpathStrategy, true, null, packageRoots_);
    }

    public ClasspathScannerDisk(ClasspathStrategy classpathStrategy, boolean reachAbstractClass, String packageRoot, String ... packageRoots_) {
        super(reachAbstractClass);
        if (packageRoot != null) {
            this.packageRoots.add(packageRoot);
        }
        for (String packageRoot_ : packageRoots_) {
            this.packageRoots.add(packageRoot_);
        }
        this.classpathStrategy = classpathStrategy;
        this.commands = new ArrayList<ScannerCommand>();
    }

    @Override
    public void scanClasspathForAnnotation(final Class<? extends Annotation> annotationType, final ClasspathScanner.Callback callback) {
        ScannerCommand command = new ScannerCommand(){

            @Override
            public Scanner scanner() {
                return new TypeAnnotationsScanner();
            }

            @Override
            public void execute(Reflections reflections) {
                Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(annotationType);
                if (typesAnnotatedWith == null) {
                    typesAnnotatedWith = Collections.emptySet();
                }
                callback.callback(ClasspathScannerDisk.this.postTreatment(typesAnnotatedWith));
            }
        };
        this.queue(command);
    }

    private void queue(ScannerCommand command) {
        this.commands.add(command);
    }

    @Override
    public void scanClasspathForMetaAnnotation(final Class<? extends Annotation> annotationType, final ClasspathScanner.Callback callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Multimap multimap = reflections.getStore().get(TypesScanner.class);
                HashSet typesAnnotatedWith = Sets.newHashSet();
                for (String className : multimap.keys()) {
                    Class klass = ClasspathScannerDisk.this.toClass(className);
                    if (annotationType == null || klass == null || !AssertUtils.hasAnnotationDeep((Class)klass, (Class)annotationType) || klass.isAnnotation()) continue;
                    typesAnnotatedWith.add(klass);
                }
                callback.callback(ClasspathScannerDisk.this.postTreatment(typesAnnotatedWith));
            }

            @Override
            public Scanner scanner() {
                return new TypesScanner();
            }
        });
    }

    @Override
    public void scanClasspathForMetaAnnotationRegex(final String metaAnnotationRegex, final ClasspathScanner.Callback callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Multimap multimap = reflections.getStore().get(TypesScanner.class);
                HashSet typesAnnotatedWith = Sets.newHashSet();
                for (String className : multimap.keys()) {
                    Class klass = ClasspathScannerDisk.this.toClass(className);
                    if (metaAnnotationRegex == null || klass == null || !AssertUtils.hasAnnotationDeepRegex((Class)klass, (String)metaAnnotationRegex) || klass.isAnnotation()) continue;
                    typesAnnotatedWith.add(klass);
                }
                callback.callback(ClasspathScannerDisk.this.postTreatment(typesAnnotatedWith));
            }

            @Override
            public Scanner scanner() {
                return new TypesScanner();
            }
        });
    }

    private Class<?> toClass(String candidate) {
        try {
            return Class.forName(candidate);
        }
        catch (Throwable e) {
            this.logger.debug("String to Class : " + e.getMessage());
            return null;
        }
    }

    @Override
    public void scanClasspathForAnnotationRegex(final String annotationTypeRegex, final ClasspathScanner.Callback callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Store store = reflections.getStore();
                Multimap multimap = store.get(TypeAnnotationsScanner.class);
                ArrayList<String> key = new ArrayList<String>();
                for (String loopKey : multimap.keySet()) {
                    if (!loopKey.matches(annotationTypeRegex)) continue;
                    key.add(loopKey);
                }
                HashSet typesAnnotatedWith = new HashSet();
                for (String k : key) {
                    Collection collectionOfString = multimap.get((Object)k);
                    typesAnnotatedWith.addAll(ClasspathScannerDisk.this.toClasses(collectionOfString));
                }
                callback.callback(ClasspathScannerDisk.this.postTreatment(typesAnnotatedWith));
            }

            @Override
            public Scanner scanner() {
                return new TypeAnnotationsScanner();
            }
        });
    }

    @Override
    public void scanClasspathForTypeRegex(final String typeName, final ClasspathScanner.Callback callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Store store = reflections.getStore();
                Multimap multimap = store.get(TypesScanner.class);
                HashSet<String> collectionOfString = new HashSet<String>();
                for (String loopKey : multimap.keySet()) {
                    if (!loopKey.matches(typeName)) continue;
                    collectionOfString.add(loopKey);
                }
                Collection<Object> types = null;
                types = collectionOfString.size() > 0 ? ClasspathScannerDisk.this.toClasses(collectionOfString) : Collections.emptySet();
                callback.callback(ClasspathScannerDisk.this.postTreatment(types));
            }

            @Override
            public Scanner scanner() {
                return new TypesScanner();
            }
        });
    }

    @Override
    public void scanClasspathForSpecification(final Specification<Class<?>> specification, final ClasspathScanner.Callback callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Store store = reflections.getStore();
                Multimap multimap = store.get(TypesScanner.class);
                Set collectionOfString = multimap.keySet();
                Collection<Object> types = null;
                HashSet<Class> filteredTypes = new HashSet<Class>();
                types = collectionOfString.size() > 0 ? ClasspathScannerDisk.this.toClasses(collectionOfString) : Collections.emptySet();
                for (Class candidate : types) {
                    if (!specification.isSatisfiedBy((Object)candidate)) continue;
                    filteredTypes.add(candidate);
                }
                callback.callback(ClasspathScannerDisk.this.postTreatment(filteredTypes));
            }

            @Override
            public Scanner scanner() {
                return new TypesScanner();
            }
        });
    }

    @Override
    public void scanClasspathForSubTypeRegex(final String subTypeName, final ClasspathScanner.Callback callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
            }

            @Override
            public Scanner scanner() {
                return new SubTypesScanner();
            }
        });
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Store store = reflections.getStore();
                Multimap multimap = store.get(TypesScanner.class);
                HashSet<String> collectionOfString = new HashSet<String>();
                for (String loopKey : multimap.keySet()) {
                    if (!loopKey.matches(subTypeName)) continue;
                    collectionOfString.add(loopKey);
                }
                Collection<Object> types = null;
                types = collectionOfString.size() > 0 ? ClasspathScannerDisk.this.toClasses(collectionOfString) : Collections.emptySet();
                HashSet finalClasses = new HashSet();
                for (Class clazz : types) {
                    Set typesAnnotatedWith = reflections.getSubTypesOf(clazz);
                    if (typesAnnotatedWith == null) {
                        typesAnnotatedWith = Collections.emptySet();
                    }
                    finalClasses.addAll(ClasspathScannerDisk.this.postTreatment(typesAnnotatedWith));
                }
                callback.callback(finalClasses);
            }

            @Override
            public Scanner scanner() {
                return new TypesScanner();
            }
        });
    }

    @Override
    public void scanClasspathForResource(final String pattern, final ClasspathScanner.CallbackResources callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Set resources = reflections.getResources(Pattern.compile(pattern));
                callback.callback(resources);
            }

            @Override
            public Scanner scanner() {
                return new ResourcesScanner();
            }
        });
    }

    @Override
    public void scanClasspathForSubTypeClass(final Class<?> subType, final ClasspathScanner.Callback callback) {
        this.queue(new ScannerCommand(){

            @Override
            public void execute(Reflections reflections) {
                Set typesAnnotatedWith = reflections.getSubTypesOf(subType);
                if (typesAnnotatedWith == null) {
                    typesAnnotatedWith = Collections.emptySet();
                }
                callback.callback(ClasspathScannerDisk.this.postTreatment(typesAnnotatedWith));
            }

            @Override
            public Scanner scanner() {
                return new SubTypesScanner();
            }
        });
    }

    @Override
    public void doClasspathScan() {
        Scanner[] scanners = this.getScanners();
        ConfigurationBuilder configurationBuilder = this.configurationBuilder().addUrls(this.computeUrls()).setScanners(scanners);
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        for (ScannerCommand command : this.commands) {
            command.execute(reflections);
        }
    }

    protected Scanner[] getScanners() {
        HashMap scannersByClass = Maps.newHashMap();
        for (ScannerCommand command : this.commands) {
            Scanner scanner = command.scanner();
            if (scannersByClass.containsKey(scanner.getClass())) continue;
            scannersByClass.put(scanner.getClass(), scanner);
        }
        Collection scanners = scannersByClass.values();
        int size = scanners.size();
        Scanner[] arrayOfScanners = new Scanner[size];
        scanners.toArray(arrayOfScanners);
        return arrayOfScanners;
    }

    public void setAdditionalClasspath(Set<URL> additionalClasspath) {
        this.additionalClasspath = additionalClasspath;
    }

    protected ConfigurationBuilder configurationBuilder() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        FilterBuilder fb = new FilterBuilder();
        for (String packageRoot : this.packageRoots) {
            fb.include(FilterBuilder.prefix((String)packageRoot));
        }
        cb.filterInputsBy((Predicate)fb);
        return cb;
    }

    private Set<URL> computeUrls() {
        if (this.urls == null) {
            this.urls = new HashSet<URL>();
            switch (this.classpathStrategy.getStrategy()) {
                case SYSTEM: {
                    this.urls.addAll(ClasspathHelper.forJavaClassPath());
                    break;
                }
                case CLASSLOADER: {
                    this.urls.addAll(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[0]));
                    break;
                }
                case ALL: {
                    this.urls.addAll(ClasspathHelper.forJavaClassPath());
                    this.urls.addAll(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[0]));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported classpath strategy " + this.classpathStrategy.toString());
                }
            }
            if (this.classpathStrategy.isAdditional() && this.additionalClasspath != null) {
                this.urls.addAll(this.additionalClasspath);
            }
        }
        return this.urls;
    }

    private <T> Collection<Class<? extends T>> toClasses(Collection<String> names) {
        return ReflectionUtils.forNames(names, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
    }

    protected static interface ScannerCommand {
        public void execute(Reflections var1);

        public Scanner scanner();
    }
}

