/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import io.nuun.kernel.api.annotations.Ignore;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.scanner.ClasspathScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClasspathScanner
implements ClasspathScanner {
    private final boolean reachAbstractClass;

    public AbstractClasspathScanner(boolean reachAbstractClass) {
        this.reachAbstractClass = reachAbstractClass;
    }

    protected Collection<Class<?>> postTreatment(Collection<Class<?>> set) {
        for (Class<?> class1 : set) {
            if (null != class1) continue;
            throw new KernelException("Scanned classes results can not be null. Please check Integrity of the classes.", new Object[0]);
        }
        Collection filtered = Collections2.filter(set, (Predicate)new IgnorePredicate(this.reachAbstractClass));
        return filtered;
    }

    static class IgnorePredicate
    implements Predicate<Class<?>> {
        Logger logger = LoggerFactory.getLogger(IgnorePredicate.class);
        private final boolean reachAbstractClass;

        public IgnorePredicate(boolean reachAbstractClass) {
            this.reachAbstractClass = reachAbstractClass;
        }

        public boolean apply(Class<?> clazz) {
            this.logger.trace("Checking {} for Ignore", (Object)clazz.getName());
            boolean toKeep = true;
            if (Modifier.isAbstract(clazz.getModifiers()) && !this.reachAbstractClass && !clazz.isInterface()) {
                toKeep = false;
            }
            for (Annotation annotation : clazz.getAnnotations()) {
                this.logger.trace("Checking annotation {} for Ignore", (Object)annotation.annotationType().getName());
                if (annotation.annotationType().equals(Ignore.class) || annotation.annotationType().getName().endsWith("Ignore")) {
                    toKeep = false;
                }
                this.logger.trace("Result tokeep = {}.", (Object)toKeep);
                if (!toKeep) break;
            }
            return toKeep;
        }
    }
}

