/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.context;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.annotations.KernelModule;
import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.RequestType;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.ModuleEmbedded;
import io.nuun.kernel.core.internal.scanner.ClasspathScanner;
import io.nuun.kernel.core.internal.scanner.ClasspathScannerFactory;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathStrategy;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryMultiThreadClasspath;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kametic.specifications.Specification;
import org.kametic.specifications.reflect.DescendantOfSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitContextInternal
implements InitContext {
    private Logger logger = LoggerFactory.getLogger(InitContextInternal.class);
    ClasspathScanner classpathScanner;
    private List<Class<?>> parentTypesClassesToScan;
    private List<Class<?>> ancestorTypesClassesToScan;
    private List<Class<?>> typesClassesToScan;
    private List<String> typesRegexToScan;
    private List<Specification<Class<?>>> specificationsToScan;
    private List<String> resourcesRegexToScan;
    private List<String> parentTypesRegexToScan;
    private List<Class<? extends Annotation>> annotationTypesToScan;
    private List<String> annotationRegexToScan;
    private List<Class<?>> parentTypesClassesToBind;
    private List<Class<?>> ancestorTypesClassesToBind;
    private List<String> parentTypesRegexToBind;
    private List<Specification<Class<?>>> specificationsToBind;
    private Map<Key, Object> mapOfScopes;
    private List<Class<? extends Annotation>> annotationTypesToBind;
    private List<Class<? extends Annotation>> metaAnnotationTypesToBind;
    private List<String> annotationRegexToBind;
    private List<String> metaAnnotationRegexToBind;
    private List<String> propertiesPrefix;
    private List<UnitModule> childModules;
    private List<UnitModule> childOverridingModules;
    private List<String> packageRoots;
    private Set<URL> additionalClasspathScan;
    private ClasspathStrategy classpathStrategy;
    private Set<Class<?>> classesToBind;
    private Map<Class<?>, Object> classesWithScopes;
    private Collection<String> propertiesFiles;
    private Map<String, String> kernelParams;
    private Map<Class<?>, Collection<Class<?>>> mapSubTypes;
    private Map<Class<?>, Collection<Class<?>>> mapAncestorTypes;
    private Map<String, Collection<Class<?>>> mapSubTypesByName;
    private Map<String, Collection<Class<?>>> mapTypesByName;
    private Map<Specification, Collection<Class<?>>> mapTypesBySpecification;
    private Map<Class<? extends Annotation>, Collection<Class<?>>> mapAnnotationTypes;
    private Map<String, Collection<Class<?>>> mapAnnotationTypesByName;
    private Map<String, Collection<String>> mapPropertiesFiles;
    private Map<String, Collection<String>> mapResourcesByRegex;
    private String initialPropertiesPrefix;
    private int roundNumber = 0;
    private ClasspathScanMode classpathScanMode;

    public InitContextInternal(String initialPropertiesPrefix, Map<String, String> kernelParams) {
        this(initialPropertiesPrefix, kernelParams, ClasspathScanMode.NOMINAL);
    }

    public InitContextInternal(String initialPropertiesPrefix, Map<String, String> kernelParams, ClasspathScanMode classpathScanMode) {
        this.classpathScanMode = classpathScanMode;
        String classpathStrategyNameParam = kernelParams.get("nuun.classpath.strategy.name");
        String classpathStrategyAdditionalParam = kernelParams.get("nuun.classpath.strategy.additional");
        this.classpathStrategy = new ClasspathStrategy(classpathStrategyNameParam == null ? ClasspathStrategy.Strategy.ALL : ClasspathStrategy.Strategy.valueOf(classpathStrategyNameParam.toUpperCase()), classpathStrategyAdditionalParam == null ? true : Boolean.parseBoolean(classpathStrategyAdditionalParam));
        this.packageRoots = new LinkedList<String>();
        this.initialPropertiesPrefix = initialPropertiesPrefix;
        this.kernelParams = kernelParams;
        this.childModules = new LinkedList<UnitModule>();
        this.childOverridingModules = new LinkedList<UnitModule>();
        this.classesToBind = new HashSet();
        this.classesWithScopes = new HashMap();
        this.reset();
    }

    public void reset() {
        this.mapSubTypes = new HashMap();
        this.mapAncestorTypes = new HashMap();
        this.mapSubTypesByName = new HashMap();
        this.mapTypesByName = new HashMap();
        this.mapTypesBySpecification = new HashMap();
        this.mapAnnotationTypes = new HashMap();
        this.mapAnnotationTypesByName = new HashMap();
        this.mapPropertiesFiles = new HashMap<String, Collection<String>>();
        this.mapResourcesByRegex = new HashMap<String, Collection<String>>();
        this.annotationTypesToScan = new LinkedList<Class<? extends Annotation>>();
        this.parentTypesClassesToScan = new LinkedList();
        this.ancestorTypesClassesToScan = new LinkedList();
        this.typesClassesToScan = new LinkedList();
        this.typesRegexToScan = new LinkedList<String>();
        this.specificationsToScan = new LinkedList();
        this.resourcesRegexToScan = new LinkedList<String>();
        this.parentTypesRegexToScan = new LinkedList<String>();
        this.annotationRegexToScan = new LinkedList<String>();
        this.annotationTypesToBind = new LinkedList<Class<? extends Annotation>>();
        this.metaAnnotationTypesToBind = new LinkedList<Class<? extends Annotation>>();
        this.parentTypesClassesToBind = new LinkedList();
        this.ancestorTypesClassesToBind = new LinkedList();
        this.parentTypesRegexToBind = new LinkedList<String>();
        this.specificationsToBind = new LinkedList();
        this.mapOfScopes = new HashMap<Key, Object>();
        this.annotationRegexToBind = new LinkedList<String>();
        this.metaAnnotationRegexToBind = new LinkedList<String>();
        this.propertiesPrefix = new LinkedList<String>();
        this.propertiesPrefix.add(this.initialPropertiesPrefix);
        this.additionalClasspathScan = new HashSet<URL>();
    }

    public void classpathScanMode(ClasspathScanMode classpathScanMode) {
        this.classpathScanMode = classpathScanMode;
    }

    private void initScanner() {
        String[] packageRootArray = new String[this.packageRoots.size()];
        this.packageRoots.toArray(packageRootArray);
        ClasspathScannerFactory classpathScannerFactory = new ClasspathScannerFactory();
        if (this.classpathScanMode == ClasspathScanMode.NOMINAL) {
            this.classpathScanner = classpathScannerFactory.create(this.classpathStrategy, this.additionalClasspathScan, packageRootArray);
        } else if (this.classpathScanMode == ClasspathScanMode.IN_MEMORY) {
            InMemoryMultiThreadClasspath classpath = InMemoryMultiThreadClasspath.INSTANCE;
            this.classpathScanner = classpathScannerFactory.createInMemory(classpath, packageRootArray);
        }
    }

    public void executeRequests() {
        Object callback;
        this.initScanner();
        ClasspathScanner.Callback callback2 = new ClasspathScanner.Callback(){

            @Override
            public void callback(Collection<Class<?>> scanResult) {
                Collection<Class<?>> scanResult2 = scanResult;
                FluentIterable nominals = FluentIterable.from(scanResult2).filter(Predicates.and((Predicate)Predicates.not((Predicate)new IsModuleOverriding()), (Predicate)Predicates.not((Predicate)new IsModuleAbstract()))).transform((Function)new ModuleClass2Instance());
                FluentIterable overriders = FluentIterable.from(scanResult2).filter(Predicates.and((Predicate)new IsModuleOverriding(), (Predicate)Predicates.not((Predicate)new IsModuleAbstract()))).transform((Function)new ModuleClass2Instance());
                InitContextInternal.this.childModules.addAll(nominals.toImmutableSet());
                InitContextInternal.this.childOverridingModules.addAll(overriders.toImmutableSet());
            }
        };
        this.classpathScanner.scanClasspathForAnnotation(KernelModule.class, callback2);
        for (final Class<?> clazz : this.parentTypesClassesToScan) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    InitContextInternal.this.mapSubTypes.put(clazz, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForSubTypeClass(clazz, (ClasspathScanner.Callback)callback);
        }
        for (final Class<?> clazz : this.ancestorTypesClassesToScan) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    InitContextInternal.this.mapAncestorTypes.put(clazz, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForSpecification((Specification<Class<?>>)new DescendantOfSpecification(clazz), (ClasspathScanner.Callback)callback);
        }
        for (final String string : this.parentTypesRegexToScan) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    InitContextInternal.this.mapSubTypesByName.put(string, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForSubTypeRegex(string, (ClasspathScanner.Callback)callback);
        }
        for (final String string : this.typesRegexToScan) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    InitContextInternal.this.mapTypesByName.put(string, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForTypeRegex(string, (ClasspathScanner.Callback)callback);
        }
        for (final Specification specification : this.specificationsToScan) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    InitContextInternal.this.mapTypesBySpecification.put(specification, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForSpecification(specification, (ClasspathScanner.Callback)callback);
        }
        for (final Class clazz : this.annotationTypesToScan) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    InitContextInternal.this.mapAnnotationTypes.put(clazz, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForAnnotation(clazz, (ClasspathScanner.Callback)callback);
        }
        for (final String string : this.annotationRegexToScan) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    InitContextInternal.this.mapAnnotationTypesByName.put(string, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForAnnotationRegex(string, (ClasspathScanner.Callback)callback);
        }
        for (final Class clazz : this.parentTypesClassesToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.SUBTYPE_OF_BY_CLASS;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, clazz), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForSubTypeClass(clazz, (ClasspathScanner.Callback)callback);
        }
        for (final Class clazz : this.ancestorTypesClassesToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.SUBTYPE_OF_BY_TYPE_DEEP;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, clazz), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForSpecification((Specification<Class<?>>)new DescendantOfSpecification(clazz), (ClasspathScanner.Callback)callback);
        }
        for (final String string : this.parentTypesRegexToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.SUBTYPE_OF_BY_REGEX_MATCH;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, string), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForTypeRegex(string, (ClasspathScanner.Callback)callback);
        }
        for (final Specification specification : this.specificationsToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.VIA_SPECIFICATION;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, specification), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForSpecification(specification, (ClasspathScanner.Callback)callback);
        }
        for (final Class clazz : this.annotationTypesToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.ANNOTATION_TYPE;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, clazz), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForAnnotation(clazz, (ClasspathScanner.Callback)callback);
        }
        for (final Class clazz : this.metaAnnotationTypesToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.META_ANNOTATION_TYPE;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, clazz), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForMetaAnnotation(clazz, (ClasspathScanner.Callback)callback);
        }
        for (final String string : this.annotationRegexToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.ANNOTATION_REGEX_MATCH;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, string), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForAnnotationRegex(string, (ClasspathScanner.Callback)callback);
        }
        for (final String string : this.metaAnnotationRegexToBind) {
            callback = new ClasspathScanner.Callback(){

                @Override
                public void callback(Collection<Class<?>> scanResult) {
                    RequestType requestType = RequestType.META_ANNOTATION_REGEX_MATCH;
                    InitContextInternal.this.addScopeToClasses(scanResult, InitContextInternal.this.scope(requestType, string), InitContextInternal.this.classesWithScopes);
                    InitContextInternal.this.classesToBind.addAll(scanResult);
                }
            };
            this.classpathScanner.scanClasspathForMetaAnnotationRegex(string, (ClasspathScanner.Callback)callback);
        }
        for (final String string : this.resourcesRegexToScan) {
            callback = new ClasspathScanner.CallbackResources(){

                @Override
                public void callback(Collection<String> scanResult) {
                    InitContextInternal.this.mapResourcesByRegex.put(string, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForResource(string, (ClasspathScanner.CallbackResources)callback);
        }
        this.propertiesFiles = new HashSet<String>();
        for (final String string : this.propertiesPrefix) {
            callback = new ClasspathScanner.CallbackResources(){

                @Override
                public void callback(Collection<String> scanResult) {
                    InitContextInternal.this.propertiesFiles.addAll(scanResult);
                    InitContextInternal.this.mapPropertiesFiles.put(string, scanResult);
                }
            };
            this.classpathScanner.scanClasspathForResource(string + ".*\\.properties", (ClasspathScanner.CallbackResources)callback);
        }
        this.classpathScanner.doClasspathScan();
    }

    private Object scope(RequestType requestType, Object spec) {
        Object scope = this.mapOfScopes.get(this.key(requestType, spec));
        if (null == scope) {
            scope = Scopes.NO_SCOPE;
        }
        return scope;
    }

    private void addScopeToClasses(Collection<Class<?>> classes, Object scope, Map<Class<?>, Object> inClassesWithScopes) {
        for (Class<?> klass : classes) {
            if (!inClassesWithScopes.containsKey(klass) && scope != null) {
                inClassesWithScopes.put(klass, scope);
                continue;
            }
            Object insideScope = inClassesWithScopes.get(klass);
            if (insideScope.equals(scope)) continue;
            String format = String.format("Class %s is already associated with scope %s but  %s", klass.getName(), insideScope, scope);
            this.logger.error(format);
            throw new KernelException(format, new Object[0]);
        }
    }

    public void addClasspathsToScan(Set<URL> paths) {
        if (paths != null && paths.size() > 0) {
            this.additionalClasspathScan.addAll(paths);
        }
    }

    public void addClasspathToScan(URL path) {
        if (path != null) {
            this.additionalClasspathScan.add(path);
        }
    }

    public Map<Class<?>, Collection<Class<?>>> scannedSubTypesByParentClass() {
        return Collections.unmodifiableMap(this.mapSubTypes);
    }

    public Map<Class<?>, Collection<Class<?>>> scannedSubTypesByAncestorClass() {
        return Collections.unmodifiableMap(this.mapAncestorTypes);
    }

    public Map<String, Collection<Class<?>>> scannedSubTypesByParentRegex() {
        return Collections.unmodifiableMap(this.mapSubTypesByName);
    }

    public Map<String, Collection<Class<?>>> scannedTypesByRegex() {
        return Collections.unmodifiableMap(this.mapTypesByName);
    }

    public Map<Specification, Collection<Class<?>>> scannedTypesBySpecification() {
        return Collections.unmodifiableMap(this.mapTypesBySpecification);
    }

    public Map<Class<? extends Annotation>, Collection<Class<?>>> scannedClassesByAnnotationClass() {
        return Collections.unmodifiableMap(this.mapAnnotationTypes);
    }

    public Map<String, Collection<Class<?>>> scannedClassesByAnnotationRegex() {
        return Collections.unmodifiableMap(this.mapAnnotationTypesByName);
    }

    public Map<String, Collection<String>> mapPropertiesFilesByPrefix() {
        return Collections.unmodifiableMap(this.mapPropertiesFiles);
    }

    public Map<String, Collection<String>> mapResourcesByRegex() {
        return Collections.unmodifiableMap(this.mapResourcesByRegex);
    }

    public void addPropertiesPrefix(String prefix) {
        this.propertiesPrefix.add(prefix);
    }

    public void addPackageRoot(String root) {
        this.packageRoots.add(root);
    }

    public void addParentTypeClassToScan(Class<?> type) {
        this.parentTypesClassesToScan.add(type);
    }

    public void addAncestorTypeClassToScan(Class<?> type) {
        this.ancestorTypesClassesToScan.add(type);
    }

    public void addResourcesRegexToScan(String regex) {
        this.resourcesRegexToScan.add(regex);
    }

    public void addTypeClassToScan(Class<?> type) {
        this.typesClassesToScan.add(type);
    }

    private Key key(RequestType type, Object key) {
        return new Key(type, key);
    }

    public void addParentTypeClassToBind(Class<?> type, Object scope) {
        this.updateScope(this.key(RequestType.SUBTYPE_OF_BY_CLASS, type), scope);
        this.parentTypesClassesToBind.add(type);
    }

    public void addAncestorTypeClassToBind(Class<?> type, Object scope) {
        this.updateScope(this.key(RequestType.SUBTYPE_OF_BY_TYPE_DEEP, type), scope);
        this.ancestorTypesClassesToBind.add(type);
    }

    public void addTypeRegexesToScan(String type) {
        this.typesRegexToScan.add(type);
    }

    public void addSpecificationToScan(Specification<Class<?>> specification) {
        this.specificationsToScan.add(specification);
    }

    public void addParentTypeRegexesToScan(String type) {
        this.parentTypesRegexToScan.add(type);
    }

    public void addTypeRegexesToBind(String type, Object scope) {
        this.updateScope(this.key(RequestType.TYPE_OF_BY_REGEX_MATCH, type), scope);
        this.parentTypesRegexToBind.add(type);
    }

    private void updateScope(Key key, Object scope) {
        if (scope != null) {
            this.mapOfScopes.put(key, scope);
        } else {
            this.mapOfScopes.put(key, Scopes.NO_SCOPE);
        }
    }

    public void addSpecificationToBind(Specification<Class<?>> specification, Object scope) {
        this.specificationsToBind.add(specification);
        this.updateScope(this.key(RequestType.VIA_SPECIFICATION, specification), scope);
    }

    public void addAnnotationTypesToScan(Class<? extends Annotation> types) {
        this.annotationTypesToScan.add(types);
    }

    public void addAnnotationTypesToBind(Class<? extends Annotation> types, Object scope) {
        this.annotationTypesToBind.add(types);
        this.updateScope(this.key(RequestType.ANNOTATION_TYPE, types), scope);
    }

    public void addMetaAnnotationTypesToBind(Class<? extends Annotation> types, Object scope) {
        this.metaAnnotationTypesToBind.add(types);
        this.updateScope(this.key(RequestType.META_ANNOTATION_TYPE, types), scope);
    }

    public void addAnnotationRegexesToScan(String names) {
        this.annotationRegexToScan.add(names);
    }

    public void addAnnotationRegexesToBind(String names, Object scope) {
        this.annotationRegexToBind.add(names);
        this.updateScope(this.key(RequestType.ANNOTATION_REGEX_MATCH, names), scope);
    }

    public void addMetaAnnotationRegexesToBind(String names, Object scope) {
        this.metaAnnotationRegexToBind.add(names);
        this.updateScope(this.key(RequestType.META_ANNOTATION_REGEX_MATCH, names), scope);
    }

    public void addChildModule(Module module) {
        this.childModules.add(new ModuleEmbedded(module));
    }

    public void addChildOverridingModule(Module module) {
        this.childOverridingModules.add(new ModuleEmbedded(module));
    }

    public String kernelParam(String key) {
        return this.kernelParams.get(key);
    }

    public Collection<Class<?>> classesToBind() {
        return Collections.unmodifiableSet(this.classesToBind);
    }

    public Map<Class<?>, Object> classesWithScopes() {
        return Collections.unmodifiableMap(this.classesWithScopes);
    }

    public List<UnitModule> moduleResults() {
        return Collections.unmodifiableList(this.childModules);
    }

    public List<UnitModule> moduleOverridingResults() {
        return Collections.unmodifiableList(this.childOverridingModules);
    }

    public Collection<String> propertiesFiles() {
        return Collections.unmodifiableCollection(this.propertiesFiles);
    }

    public Collection<? extends Plugin> pluginsRequired() {
        return Collections.emptySet();
    }

    public Collection<? extends Plugin> dependentPlugins() {
        return Collections.emptySet();
    }

    public int roundNumber() {
        return this.roundNumber;
    }

    public void roundNumber(int roundNumber) {
        this.roundNumber = roundNumber;
    }

    static class Key {
        private final RequestType type;
        private final Object key;

        public Key(RequestType type, Object key) {
            this.type = type;
            this.key = key;
        }

        public boolean equals(Object obj) {
            Key key2 = (Key)obj;
            return new EqualsBuilder().append((Object)this.type, (Object)key2.type).append(this.key, key2.key).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.type).append(this.key).toHashCode();
        }
    }

    class ModuleClass2Instance
    implements Function<Class<? extends Module>, UnitModule> {
        ModuleClass2Instance() {
        }

        public UnitModule apply(Class<? extends Module> classpathClass) {
            try {
                return new ModuleEmbedded(classpathClass.newInstance());
            }
            catch (InstantiationException e) {
                InitContextInternal.this.logger.warn("Error when instantiating module " + classpathClass, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                InitContextInternal.this.logger.warn("Error when instantiating module " + classpathClass, (Throwable)e);
            }
            return null;
        }
    }

    class IsModuleAbstract
    implements Predicate<Class<? extends Module>> {
        IsModuleAbstract() {
        }

        public boolean apply(Class<? extends Module> input) {
            return Modifier.isAbstract(input.getModifiers());
        }
    }

    class IsModuleOverriding
    implements Predicate<Class<? extends Module>> {
        IsModuleOverriding() {
        }

        public boolean apply(Class<? extends Module> input) {
            KernelModule annotation = input.getAnnotation(KernelModule.class);
            return annotation.overriding();
        }
    }
}

