/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.context;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Injector;
import com.google.inject.Key;
import io.nuun.kernel.api.plugin.context.Context;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ContextInternal
implements Context {
    public final Injector mainInjector;

    @Inject
    public ContextInternal(Injector mainInjector) {
        this.mainInjector = mainInjector;
    }

    public Collection<Class<?>> getClassAnnotatedWith(Class<? extends Annotation> clazz) {
        Collection resultKeys = Collections2.filter(this.mainInjector.getAllBindings().keySet(), this.withAnnotation(clazz));
        return Collections2.transform((Collection)resultKeys, this.fromKeyTClass());
    }

    public Collection<Class<?>> getClassAnnotatedWithRegex(String regex) {
        Collection resultKeys = Collections2.filter(this.mainInjector.getAllBindings().keySet(), this.withAnnotationName(regex));
        return Collections2.transform((Collection)resultKeys, this.fromKeyTClass());
    }

    public Collection<Class<?>> getClassWithParentType(Class<?> parentClass) {
        Collection resultKeys = Collections2.filter(this.mainInjector.getAllBindings().keySet(), this.withParentType(parentClass));
        return Collections2.transform((Collection)resultKeys, this.fromKeyTClass());
    }

    public Collection<Class<?>> getClassTypeByRegex(String typeNameRegex) {
        Collection resultKeys = Collections2.filter(this.mainInjector.getAllBindings().keySet(), this.withTypeName(typeNameRegex));
        return Collections2.transform((Collection)resultKeys, this.fromKeyTClass());
    }

    private Predicate<Key<?>> withTypeName(final String typeNameSuffix) {
        return new Predicate<Key<?>>(){

            public boolean apply(@Nullable Key<?> input) {
                return input != null && input.getTypeLiteral().getRawType().getName().matches(typeNameSuffix);
            }
        };
    }

    private Predicate<Key<?>> withParentType(final Class<?> parentType) {
        return new Predicate<Key<?>>(){

            public boolean apply(@Nullable Key<?> input) {
                boolean value1 = input != null;
                boolean value2 = false;
                if (value1) {
                    Class s\u00fcper = input.getTypeLiteral().getRawType().getSuperclass();
                    if (s\u00fcper != null && s\u00fcper != Object.class) {
                        boolean bl = value2 = s\u00fcper == parentType;
                    }
                    if (!value2) {
                        Class<?>[] interfaces;
                        for (Class<?> class1 : interfaces = input.getTypeLiteral().getRawType().getInterfaces()) {
                            boolean bl = value2 = class1 == parentType;
                            if (value2) break;
                        }
                    }
                }
                return value1 && value2;
            }
        };
    }

    private Predicate<Key<?>> withAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<Key<?>>(){

            public boolean apply(@Nullable Key<?> input) {
                return input != null && input.getTypeLiteral().getRawType().isAnnotationPresent(annotation);
            }
        };
    }

    private Predicate<Key<?>> withAnnotationName(final String annotationNameRegex) {
        return new Predicate<Key<?>>(){

            public boolean apply(@Nullable Key<?> input) {
                boolean value1 = input != null;
                boolean value2 = false;
                if (value1) {
                    for (Annotation annotation : input.getTypeLiteral().getRawType().getAnnotations()) {
                        if (!annotation.annotationType().getName().matches(annotationNameRegex)) continue;
                        value2 = true;
                        break;
                    }
                }
                return value1 && value2;
            }
        };
    }

    private Function<Key<?>, Class<?>> fromKeyTClass() {
        return new Function<Key<?>, Class<?>>(){

            public Class<?> apply(Key<?> input) {
                return input.getTypeLiteral().getRawType();
            }
        };
    }
}

