/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.matcher.Matchers;
import com.google.inject.util.Providers;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.context.Context;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.context.ContextInternal;
import io.nuun.kernel.core.internal.context.InitContextInternal;
import io.nuun.kernel.spi.Concern;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelGuiceModuleInternal
extends AbstractModule {
    private Logger logger = LoggerFactory.getLogger(KernelGuiceModuleInternal.class);
    private final InitContextInternal currentContext;
    private boolean overriding = false;

    public KernelGuiceModuleInternal(InitContextInternal kernelContext) {
        this.currentContext = kernelContext;
    }

    public KernelGuiceModuleInternal overriding() {
        this.overriding = true;
        return this;
    }

    protected final void configure() {
        this.binder().requireExplicitBindings();
        this.bind(Context.class).to(ContextInternal.class);
        this.bindFromClasspath();
    }

    private void bindFromClasspath() {
        ArrayList<Installable> installableList = new ArrayList<Installable>();
        Map<Class<?>, Object> classesWithScopes = this.currentContext.classesWithScopes();
        if (!this.overriding) {
            Collection<Class<?>> classes = this.currentContext.classesToBind();
            for (Class<?> clazz : classes) {
                installableList.add(new Installable(clazz));
            }
            for (Class<?> clazz : this.currentContext.moduleResults()) {
                installableList.add(new Installable(clazz));
            }
        } else {
            this.logger.info("Installing overriding modules");
            for (UnitModule o : this.currentContext.moduleOverridingResults()) {
                installableList.add(new Installable(o));
            }
        }
        Collections.sort(installableList, Collections.reverseOrder());
        Provider nullProvider = Providers.of(null);
        for (Installable installable : installableList) {
            Object installableInner = installable.inner;
            if (UnitModule.class.isAssignableFrom(installableInner.getClass())) {
                Object moduleObject = ((UnitModule)UnitModule.class.cast(installableInner)).nativeModule();
                if (Module.class.isAssignableFrom(moduleObject.getClass())) {
                    this.logger.info("installing module {}", moduleObject);
                    this.install((Module)Module.class.cast(moduleObject));
                } else {
                    throw new KernelException("Can not install " + moduleObject + ". It is not a Guice Module", new Object[0]);
                }
            }
            if (!(installableInner instanceof Class)) continue;
            Class classpathClass = (Class)Class.class.cast(installableInner);
            Object scope = classesWithScopes.get(classpathClass);
            if (!classpathClass.isInterface() || !ReflectionUtils.withAnnotation(Nullable.class).apply((Object)classpathClass)) {
                if (scope == null) {
                    this.logger.info("binding {} with no scope.", (Object)classpathClass.getName());
                    this.bind(classpathClass);
                    continue;
                }
                this.logger.info("binding {} in scope {}.", (Object)classpathClass.getName(), (Object)scope.toString());
                this.bind(classpathClass).in((Scope)scope);
                continue;
            }
            this.bind(classpathClass).toProvider(nullProvider);
        }
    }

    Long computeOrder(Class<?> moduleCl\u00e4ss) {
        Long finalOrder = 0L;
        boolean reachAtLeastOnce = false;
        for (Annotation annotation : moduleCl\u00e4ss.getAnnotations()) {
            if (!Matchers.annotatedWith(Concern.class).matches(annotation.annotationType())) continue;
            reachAtLeastOnce = true;
            Concern concern = annotation.annotationType().getAnnotation(Concern.class);
            switch (concern.priority()) {
                case HIGHEST: {
                    finalOrder = finalOrder + (0x300000000L + (long)concern.order());
                    break;
                }
                case HIGHER: {
                    finalOrder = finalOrder + (0x200000000L + (long)concern.order());
                    break;
                }
                case HIGH: {
                    finalOrder = finalOrder + (0x100000000L + (long)concern.order());
                    break;
                }
                case NORMAL: {
                    finalOrder = concern.order();
                    break;
                }
                case LOW: {
                    finalOrder = finalOrder - (0x100000000L + (long)concern.order());
                    break;
                }
                case LOWER: {
                    finalOrder = finalOrder - (0x200000000L + (long)concern.order());
                    break;
                }
                case LOWEST: {
                    finalOrder = finalOrder - (0x300000000L + (long)concern.order());
                    break;
                }
            }
            break;
        }
        if (!reachAtLeastOnce) {
            finalOrder = 0L;
        }
        return finalOrder;
    }

    public static boolean hasAnnotationDeep(Class<?> memberDeclaringClass, Class<? extends Annotation> klass) {
        if (memberDeclaringClass.equals(klass)) {
            return true;
        }
        for (Annotation anno : memberDeclaringClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            if (annoClass.getPackage().getName().startsWith("java.lang") || !KernelGuiceModuleInternal.hasAnnotationDeep(annoClass, klass)) continue;
            return true;
        }
        return false;
    }

    class Installable
    implements Comparable<Installable> {
        Object inner;

        Installable(Object inner) {
            this.inner = inner;
        }

        @Override
        public int compareTo(Installable anInstallable) {
            Class<?> innerClass;
            Class<?> toCompare;
            if (anInstallable.inner instanceof Class) {
                toCompare = (Class<?>)anInstallable.inner;
            } else if (Module.class.isAssignableFrom(anInstallable.inner.getClass())) {
                toCompare = anInstallable.inner.getClass();
            } else if (UnitModule.class.isAssignableFrom(anInstallable.inner.getClass())) {
                toCompare = ((UnitModule)UnitModule.class.cast(anInstallable.inner)).nativeModule().getClass();
            } else {
                throw new IllegalStateException("Object to compare is not a class nor a Module " + anInstallable);
            }
            if (this.inner instanceof Class) {
                innerClass = (Class<?>)this.inner;
            } else if (Module.class.isAssignableFrom(this.inner.getClass())) {
                innerClass = this.inner.getClass();
            } else if (UnitModule.class.isAssignableFrom(this.inner.getClass())) {
                innerClass = ((UnitModule)UnitModule.class.cast(this.inner)).nativeModule().getClass();
            } else {
                throw new IllegalStateException("Object to compare is not a class nor a Module " + this);
            }
            return KernelGuiceModuleInternal.this.computeOrder(innerClass).compareTo(KernelGuiceModuleInternal.this.computeOrder(toCompare));
        }

        public String toString() {
            return this.inner.toString();
        }
    }
}

