/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import io.nuun.kernel.api.Kernel;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.api.config.DependencyInjectionMode;
import io.nuun.kernel.api.di.GlobalModule;
import io.nuun.kernel.api.di.ModuleValidation;
import io.nuun.kernel.api.di.ObjectGraph;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.RoundEnvironementInternal;
import io.nuun.kernel.api.plugin.RoundEnvironment;
import io.nuun.kernel.api.plugin.context.Context;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.BindingRequest;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.api.plugin.request.KernelParamsRequest;
import io.nuun.kernel.api.plugin.request.KernelParamsRequestType;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.AliasMap;
import io.nuun.kernel.core.internal.KernelConfigurationInternal;
import io.nuun.kernel.core.internal.KernelGuiceModuleInternal;
import io.nuun.kernel.core.internal.ModuleEmbedded;
import io.nuun.kernel.core.internal.context.InitContextInternal;
import io.nuun.kernel.core.internal.graph.Graph;
import io.nuun.kernel.spi.DependencyInjectionProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KernelCore
implements Kernel {
    private final int MAXIMAL_ROUND_NUMBER = 50;
    private final Logger logger;
    private static ConcurrentHashMap<String, Kernel> kernels = new ConcurrentHashMap();
    private final String name;
    private final String NUUN_PROPERTIES_PREFIX = "nuun-";
    private ServiceLoader<Plugin> pluginLoader;
    private boolean spiPluginEnabled = true;
    private Map<String, Plugin> plugins = Collections.synchronizedMap(new HashMap());
    private Map<String, Plugin> pluginsToAdd = Collections.synchronizedMap(new HashMap());
    private final InitContextInternal initContext;
    private Injector mainInjector;
    private final AliasMap kernelParamsAndAlias = new AliasMap();
    private boolean started = false;
    private boolean initialized = false;
    private Context context;
    private Collection<DependencyInjectionProvider> dependencyInjectionProviders;
    private Object containerContext;
    private ArrayList<Plugin> orderedPlugins;
    private Collection<DependencyInjectionProvider> globalDependencyInjectionProviders;
    private List<Iterator<Plugin>> pluginIterators;
    private List<Plugin> fetchedPlugins;
    private Set<URL> globalAdditionalClasspath;
    private RoundEnvironementInternal roundEnv;
    private DependencyInjectionMode dependencyInjectionMode;
    private ClasspathScanMode classpathScanMode = ClasspathScanMode.NOMINAL;
    private final List<ModuleValidation> globalModuleValidations = Collections.synchronizedList(new ArrayList());
    private final Map<Class<? extends Plugin>, UnitModule> unitModules = Maps.newConcurrentMap();
    private final Map<Class<? extends Plugin>, UnitModule> overridingUnitModules = Maps.newConcurrentMap();
    private final Map<Class<? extends Plugin>, UnitModule> nonGuiceUnitModules = Maps.newConcurrentMap();
    private final Map<Class<? extends Plugin>, UnitModule> nonGuiceOverridingUnitModules = Maps.newConcurrentMap();
    private Module mainFinalModule;

    KernelCore(KernelConfigurationInternal kernelConfigurationInternal) {
        this.name = "Kernel-" + kernels.size();
        this.logger = LoggerFactory.getLogger((String)(KernelCore.class.getPackage().getName() + '.' + this.name()));
        this.initContext = new InitContextInternal("nuun-", this.kernelParamsAndAlias, this.classpathScanMode);
        if (kernels.contains(this.name())) {
            throw new KernelException(String.format("A kernel named %s already exists", this.name()), new Object[0]);
        }
        kernels.put(this.name(), this);
        kernelConfigurationInternal.apply(this);
    }

    public String name() {
        return this.name;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void init() {
        if (this.initialized) {
            throw new KernelException("Kernel is already initialized", new Object[0]);
        }
        this.fetchPlugins();
        this.computeAliases();
        this.initRoundEnvironment();
        this.checkPlugins();
        this.fetchGlobalParametersFromPlugins();
        this.initPlugins();
        this.computeGlobalModuleProviders();
        this.initialized = true;
    }

    private void initRoundEnvironment() {
        this.roundEnv = new RoundEnvironementInternal();
        for (Plugin plugin : this.fetchedPlugins) {
            plugin.provideRoundEnvironment((RoundEnvironment)this.roundEnv);
        }
    }

    private void fetchGlobalParametersFromPlugins() {
        this.globalDependencyInjectionProviders = new HashSet<DependencyInjectionProvider>();
        this.globalAdditionalClasspath = Sets.newHashSet();
        for (Plugin plugin : this.plugins.values()) {
            DependencyInjectionProvider iocProvider;
            plugin.provideContainerContext(this.containerContext);
            String name = plugin.name();
            this.logger.info("Get additional classpath to scan from Plugin {}.", (Object)name);
            Set computeAdditionalClasspathScan = plugin.computeAdditionalClasspathScan();
            if (computeAdditionalClasspathScan != null && computeAdditionalClasspathScan.size() > 0) {
                this.logger.info("Adding from Plugin {} start.", (Object)name);
                for (URL url : computeAdditionalClasspathScan) {
                    if (url == null) continue;
                    this.globalAdditionalClasspath.add(url);
                    this.logger.debug(url.toExternalForm());
                }
                this.logger.info("Adding from Plugin {} end. {} elements.", (Object)name, (Object)("" + computeAdditionalClasspathScan.size()));
            }
            if ((iocProvider = plugin.dependencyInjectionProvider()) == null) continue;
            this.globalDependencyInjectionProviders.add(iocProvider);
        }
    }

    private void fetchPlugins() {
        Iterator<Plugin> iterator1 = this.pluginsToAdd.values().iterator();
        if (this.spiPluginEnabled) {
            this.pluginLoader = ServiceLoader.load(Plugin.class, Thread.currentThread().getContextClassLoader());
            Iterator<Plugin> iterator2 = this.pluginLoader.iterator();
            this.pluginIterators = Arrays.asList(iterator2, iterator1);
        } else {
            this.pluginIterators = Arrays.asList(iterator1);
        }
        this.fetchedPlugins = new LinkedList<Plugin>();
        for (Iterator<Plugin> iterator : this.pluginIterators) {
            while (iterator.hasNext()) {
                Plugin plugin = iterator.next();
                this.fetchedPlugins.add(plugin);
            }
        }
    }

    private void computeAliases() {
        for (Plugin plugin : this.fetchedPlugins) {
            Map pluginKernelParametersAliases = plugin.kernelParametersAliases();
            for (Map.Entry entry : pluginKernelParametersAliases.entrySet()) {
                this.logger.info("Adding alias parameter \"{}\" to key \"{}\".", entry.getKey(), entry.getValue());
                this.kernelParamsAndAlias.putAlias((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.kernelParamsAndAlias.containsKey("nuun.root.package")) {
            String tmp = this.kernelParamsAndAlias.get("nuun.root.package");
            this.fillPackagesRoot(tmp);
        }
    }

    private void checkPlugins() {
        this.logger.info("Plugins initialisation ");
        this.plugins.clear();
        ArrayList pluginClasses = new ArrayList();
        for (Plugin plugin : this.fetchedPlugins) {
            String pluginName = plugin.name();
            this.logger.info("checking Plugin {}.", (Object)pluginName);
            if (!Strings.isNullOrEmpty((String)pluginName)) {
                Plugin ok = this.plugins.put(pluginName, plugin);
                if (ok == null) {
                    Collection kernelParamsRequests = plugin.kernelParamsRequests();
                    HashSet<String> computedMandatoryParams = new HashSet<String>();
                    for (KernelParamsRequest kernelParamsRequest : kernelParamsRequests) {
                        if (kernelParamsRequest.requestType != KernelParamsRequestType.MANDATORY) continue;
                        computedMandatoryParams.add(kernelParamsRequest.keyRequested);
                    }
                    if (this.kernelParamsAndAlias.containsAllKeys(computedMandatoryParams)) {
                        pluginClasses.add(plugin.getClass());
                        continue;
                    }
                    this.logger.error("plugin {} miss parameter/s : {}", (Object)pluginName, (Object)kernelParamsRequests.toString());
                    throw new KernelException("plugin " + pluginName + " miss parameter/s : " + kernelParamsRequests.toString(), new Object[0]);
                }
                this.logger.error("Can not have 2 Plugin {} of the same type {}. please fix this before the kernel can start.", (Object)pluginName, (Object)plugin.getClass().getName());
                throw new KernelException("Can not have 2 Plugin %s of the same type %s. please fix this before the kernel can start.", pluginName, plugin.getClass().getName());
            }
            this.logger.warn("Plugin {} has no correct name it won't be installed.", plugin.getClass());
            throw new KernelException("Plugin %s has no correct name it won't be installed.", pluginName);
        }
        for (Plugin plugin : this.plugins.values()) {
            Collection pluginDependenciesRequired = plugin.requiredPlugins();
            if (pluginDependenciesRequired != null && !pluginDependenciesRequired.isEmpty() && !pluginClasses.containsAll(pluginDependenciesRequired)) {
                this.logger.error("plugin {} misses the following plugin/s as dependency/ies {}", (Object)plugin.name(), (Object)pluginDependenciesRequired.toString());
                throw new KernelException("plugin %s misses the following plugin/s as dependency/ies %s", plugin.name(), pluginDependenciesRequired.toString());
            }
            Collection dependentPlugin = plugin.dependentPlugins();
            if (dependentPlugin == null || dependentPlugin.isEmpty() || pluginClasses.containsAll(dependentPlugin)) continue;
            this.logger.error("plugin {} misses the following plugin/s as dependee/s {}", (Object)plugin.name(), (Object)dependentPlugin.toString());
            throw new KernelException("plugin %s misses the following plugin/s as dependee/s %s", plugin.name(), dependentPlugin.toString());
        }
    }

    public synchronized void start() {
        if (this.initialized) {
            Stage stage = Stage.PRODUCTION;
            if (this.dependencyInjectionMode == DependencyInjectionMode.PRODUCTION) {
                stage = Stage.PRODUCTION;
            } else if (this.dependencyInjectionMode == DependencyInjectionMode.DEVELOPMENT) {
                stage = Stage.DEVELOPMENT;
            } else if (this.dependencyInjectionMode == DependencyInjectionMode.TOOL) {
                stage = Stage.TOOL;
            }
            this.mainInjector = Guice.createInjector((Stage)stage, (Module[])new Module[]{this.mainFinalModule});
            this.context = (Context)this.mainInjector.getInstance(Context.class);
            for (Plugin plugin : this.orderedPlugins) {
                this.mainInjector.injectMembers((Object)plugin);
                plugin.start(this.context);
            }
        } else {
            throw new KernelException("Kernel is not initialized.", new Object[0]);
        }
        this.started = true;
    }

    public ObjectGraph objectGraph() {
        return new ObjectGraphEmbedded(this.mainInjector);
    }

    public UnitModule unitModule(Class<? extends Plugin> pluginClass) {
        return this.unitModules.get(pluginClass);
    }

    public UnitModule overridingUnitModule(Class<? extends Plugin> pluginClass) {
        return this.overridingUnitModules.get(pluginClass);
    }

    public UnitModule nonGuiceUnitModule(Class<? extends Plugin> plugin) {
        return this.nonGuiceUnitModules.get(plugin);
    }

    public UnitModule nonGuiceOverridingUnitModule(Class<? extends Plugin> plugin) {
        return this.nonGuiceOverridingUnitModules.get(plugin);
    }

    public GlobalModule globalModule() {
        return (GlobalModule)GlobalModule.class.cast(new ModuleEmbedded(this.mainFinalModule));
    }

    public List<Plugin> plugins() {
        return null;
    }

    public void stop() {
        if (this.started) {
            ListIterator<Plugin> li = this.orderedPlugins.listIterator(this.orderedPlugins.size());
            while (li.hasPrevious()) {
                Plugin plugin = li.previous();
                plugin.stop();
            }
        } else {
            throw new KernelException("Kernel is not started.", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initPlugins() {
        this.initContext.reset();
        Collection<Plugin> globalPlugins = this.plugins.values();
        ArrayList<Plugin> unOrderedPlugins = new ArrayList<Plugin>(globalPlugins);
        this.logger.info("unordered plugins: (" + unOrderedPlugins.size() + ") " + unOrderedPlugins);
        this.orderedPlugins = this.sortPlugins(unOrderedPlugins);
        this.logger.info("ordered plugins: (" + this.orderedPlugins.size() + ") " + this.orderedPlugins);
        HashMap<String, InitState> states = new HashMap<String, InitState>();
        ArrayList<Object> roundOrderedPlugins = new ArrayList<Plugin>(this.orderedPlugins);
        do {
            this.initContext.roundNumber(this.roundEnv.roundNumber());
            this.logger.info("ROUND " + this.roundEnv.roundNumber() + " of the kernel initialisation.");
            for (Plugin plugin : roundOrderedPlugins) {
                Collection bindingRequests;
                String string = plugin.pluginPropertiesPrefix();
                if (!Strings.isNullOrEmpty((String)string)) {
                    this.initContext.addPropertiesPrefix(string);
                }
                String pluginPackageRoot = plugin.pluginPackageRoot();
                this.fillPackagesRoot(pluginPackageRoot);
                Collection classpathScanRequests = plugin.classpathScanRequests();
                if (classpathScanRequests != null && classpathScanRequests.size() > 0) {
                    block22: for (ClasspathScanRequest request : classpathScanRequests) {
                        switch (request.requestType) {
                            case ANNOTATION_TYPE: {
                                this.initContext.addAnnotationTypesToScan((Class)request.objectRequested);
                                continue block22;
                            }
                            case ANNOTATION_REGEX_MATCH: {
                                this.initContext.addAnnotationRegexesToScan((String)request.objectRequested);
                                continue block22;
                            }
                            case SUBTYPE_OF_BY_CLASS: {
                                this.initContext.addParentTypeClassToScan((Class)request.objectRequested);
                                continue block22;
                            }
                            case SUBTYPE_OF_BY_TYPE_DEEP: {
                                this.initContext.addAncestorTypeClassToScan((Class)request.objectRequested);
                                continue block22;
                            }
                            case SUBTYPE_OF_BY_REGEX_MATCH: {
                                this.initContext.addParentTypeRegexesToScan((String)request.objectRequested);
                                continue block22;
                            }
                            case RESOURCES_REGEX_MATCH: {
                                this.initContext.addResourcesRegexToScan((String)request.objectRequested);
                                continue block22;
                            }
                            case TYPE_OF_BY_REGEX_MATCH: {
                                this.initContext.addTypeRegexesToScan((String)request.objectRequested);
                                continue block22;
                            }
                            case VIA_SPECIFICATION: {
                                this.initContext.addSpecificationToScan(request.specification);
                                continue block22;
                            }
                        }
                        this.logger.warn("{} is not a ClasspathScanRequestType a o_O", (Object)request.requestType);
                    }
                }
                if ((bindingRequests = plugin.bindingRequests()) == null || bindingRequests.size() <= 0) continue;
                block23: for (BindingRequest request : bindingRequests) {
                    switch (request.requestType) {
                        case ANNOTATION_TYPE: {
                            this.initContext.addAnnotationTypesToBind((Class)request.requestedObject, request.requestedScope);
                            continue block23;
                        }
                        case ANNOTATION_REGEX_MATCH: {
                            this.initContext.addAnnotationRegexesToBind((String)request.requestedObject, request.requestedScope);
                            continue block23;
                        }
                        case META_ANNOTATION_TYPE: {
                            this.initContext.addMetaAnnotationTypesToBind((Class)request.requestedObject, request.requestedScope);
                            continue block23;
                        }
                        case META_ANNOTATION_REGEX_MATCH: {
                            this.initContext.addMetaAnnotationRegexesToBind((String)request.requestedObject, request.requestedScope);
                            continue block23;
                        }
                        case SUBTYPE_OF_BY_CLASS: {
                            this.initContext.addParentTypeClassToBind((Class)request.requestedObject, request.requestedScope);
                            continue block23;
                        }
                        case SUBTYPE_OF_BY_TYPE_DEEP: {
                            this.initContext.addAncestorTypeClassToBind((Class)request.requestedObject, request.requestedScope);
                            continue block23;
                        }
                        case SUBTYPE_OF_BY_REGEX_MATCH: {
                            this.initContext.addTypeRegexesToBind((String)request.requestedObject, request.requestedScope);
                            continue block23;
                        }
                        case VIA_SPECIFICATION: {
                            this.initContext.addSpecificationToBind(request.specification, request.requestedScope);
                            continue block23;
                        }
                    }
                    this.logger.warn("{} is not a BindingRequestType o_O !", (Object)request.requestType);
                }
            }
            for (URL uRL : this.globalAdditionalClasspath) {
                this.initContext.addClasspathToScan(uRL);
            }
            this.initContext.executeRequests();
            for (Plugin plugin : roundOrderedPlugins) {
                void var7_17;
                InitContextInternal initContextInternal = this.initContext;
                Collection requiredPluginsClasses = plugin.requiredPlugins();
                Collection dependentPluginsClasses = plugin.dependentPlugins();
                if (this.roundEnv.roundNumber() == 0 && requiredPluginsClasses != null && !requiredPluginsClasses.isEmpty() || dependentPluginsClasses != null && !dependentPluginsClasses.isEmpty()) {
                    Collection<Plugin> requiredPlugins = this.filterPlugins(globalPlugins, requiredPluginsClasses);
                    Collection<Plugin> dependentPlugins = this.filterPlugins(globalPlugins, dependentPluginsClasses);
                    InitContext initContext = this.proxyfy(this.initContext, requiredPlugins, dependentPlugins);
                }
                String name = plugin.name();
                this.logger.info("initializing Plugin {}.", (Object)name);
                InitState state = plugin.init((InitContext)var7_17);
                states.put(name, state);
            }
            ArrayList<Plugin> nextRoundOrderedPlugins = new ArrayList<Plugin>();
            for (Plugin plugin : roundOrderedPlugins) {
                String pluginName = plugin.name();
                InitState state = (InitState)states.get(pluginName);
                if (state == InitState.INITIALIZED) {
                    UnitModule unitModule = plugin.unitModule();
                    boolean override = false;
                    this.handleUnitModule(plugin, pluginName, unitModule, override);
                    UnitModule overridingUnitModule = plugin.overridingUnitModule();
                    boolean override2 = true;
                    this.handleUnitModule(plugin, pluginName, overridingUnitModule, override2);
                    if (unitModule != null || overridingUnitModule != null) continue;
                    this.logger.warn("For information Plugin {} does not provide any UnitModule via unitModule() nor overrindingUnitModule().", (Object)pluginName);
                    continue;
                }
                this.logger.info("Plugin " + pluginName + " is not initialized. We set it for a new round");
                nextRoundOrderedPlugins.add(plugin);
            }
            roundOrderedPlugins = nextRoundOrderedPlugins;
            this.roundEnv.incrementRoundNumber();
        } while (!roundOrderedPlugins.isEmpty() && this.roundEnv.roundNumber() < 50);
    }

    private void handleUnitModule(Plugin plugin, String pluginName, UnitModule unitModule, boolean override) {
        if (unitModule != null && unitModule.nativeModule() != null) {
            if (!Module.class.isAssignableFrom(unitModule.nativeModule().getClass())) {
                if (!override) {
                    this.nonGuiceUnitModules.put(plugin.getClass(), unitModule);
                } else {
                    this.nonGuiceOverridingUnitModules.put(plugin.getClass(), unitModule);
                }
                unitModule = this.convertNativeModule(pluginName, unitModule.nativeModule(), override);
            }
            this.validateUnitModule(unitModule);
            if (!override) {
                this.initContext.addChildModule((Module)Module.class.cast(unitModule.nativeModule()));
                this.unitModules.put(plugin.getClass(), unitModule);
            } else {
                this.initContext.addChildOverridingModule((Module)Module.class.cast(unitModule.nativeModule()));
                this.overridingUnitModules.put(plugin.getClass(), unitModule);
            }
        }
    }

    private void computeGlobalModuleProviders() {
        KernelGuiceModuleInternal kernelGuiceModuleInternal = new KernelGuiceModuleInternal(this.initContext);
        KernelGuiceModuleInternal internalKernelGuiceModuleOverriding = new KernelGuiceModuleInternal(this.initContext).overriding();
        this.mainFinalModule = Modules.override((Module[])new Module[]{kernelGuiceModuleInternal}).with(new Module[]{internalKernelGuiceModuleOverriding});
    }

    private void validateUnitModule(UnitModule unitModule) {
        for (ModuleValidation validation : this.globalModuleValidations) {
            if (!validation.canHandle(unitModule.nativeModule().getClass())) continue;
            try {
                validation.validate(unitModule);
            }
            catch (Exception validationException) {
                throw new KernelException("Error when validating di definition " + unitModule, validationException);
            }
        }
    }

    private void fillPackagesRoot(String pluginPackageRoot) {
        if (!Strings.isNullOrEmpty((String)pluginPackageRoot)) {
            String[] packages = null;
            for (String pack : packages = pluginPackageRoot.split(",")) {
                this.logger.info("Adding {} as package root", (Object)pack);
                this.initContext.addPackageRoot(pack.trim());
            }
        }
    }

    private UnitModule convertNativeModule(String pluginName, Object nativeUnitModule, boolean override) {
        DependencyInjectionProvider provider = this.findDependencyInjectionProvider(nativeUnitModule);
        if (provider != null) {
            UnitModule unitModule = provider.convert(nativeUnitModule);
            return unitModule;
        }
        this.logger.error("Kernel did not recognize module {} of plugin {}", nativeUnitModule, (Object)pluginName);
        throw new KernelException("Kernel did not recognize module %s of plugin %s. Please provide a DependencyInjectionProvider.", nativeUnitModule.toString(), pluginName);
    }

    private DependencyInjectionProvider findDependencyInjectionProvider(Object pluginDependencyInjectionDef) {
        DependencyInjectionProvider provider = null;
        for (DependencyInjectionProvider providerIt : this.globalDependencyInjectionProviders) {
            if (!providerIt.canHandle(pluginDependencyInjectionDef.getClass())) continue;
            provider = providerIt;
            break;
        }
        return provider;
    }

    private ArrayList<Plugin> sortPlugins(ArrayList<Plugin> unsortedPlugins) {
        Graph graph = new Graph(unsortedPlugins.size());
        ArrayList<Plugin> sorted = new ArrayList<Plugin>();
        HashMap<Integer, Plugin> idxPlug = new HashMap<Integer, Plugin>();
        HashMap<Character, Plugin> charPlug = new HashMap<Character, Plugin>();
        HashMap<Plugin, Integer> plugIdx = new HashMap<Plugin, Integer>();
        HashMap classPlugIdx = new HashMap();
        for (int i = 0; i < unsortedPlugins.size(); i = (int)((short)(i + 1))) {
            char c = (char)i;
            Plugin unsortedPlugin = unsortedPlugins.get(i);
            Integer pluginIndex = graph.addVertex(c);
            charPlug.put(Character.valueOf(c), unsortedPlugin);
            idxPlug.put(pluginIndex, unsortedPlugin);
            plugIdx.put(unsortedPlugin, pluginIndex);
            classPlugIdx.put(unsortedPlugin.getClass(), pluginIndex);
        }
        for (Map.Entry entry : idxPlug.entrySet()) {
            int end;
            int start;
            Plugin source = (Plugin)entry.getValue();
            for (Class dependencyClass : source.requiredPlugins()) {
                start = (Integer)classPlugIdx.get(dependencyClass);
                end = (Integer)plugIdx.get(source);
                graph.addEdge(start, end);
            }
            for (Class dependencyClass : source.dependentPlugins()) {
                start = (Integer)plugIdx.get(source);
                end = (Integer)classPlugIdx.get(dependencyClass);
                graph.addEdge(start, end);
            }
        }
        char[] topologicalSort = graph.topologicalSort();
        if (topologicalSort != null) {
            char[] arr$ = topologicalSort;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character c = Character.valueOf(arr$[i$]);
                sorted.add((Plugin)charPlug.get(c));
            }
        } else {
            throw new KernelException("Error when sorting plugins : either a Cycle in dependencies or another cause.", new Object[0]);
        }
        return sorted;
    }

    private Collection<Plugin> filterPlugins(Collection<Plugin> collection, Collection<Class<? extends Plugin>> pluginDependenciesRequired) {
        HashSet<Plugin> filteredSet = new HashSet<Plugin>();
        for (Plugin plugin : collection) {
            if (!pluginDependenciesRequired.contains(plugin.getClass())) continue;
            filteredSet.add(plugin);
        }
        return filteredSet;
    }

    private InitContext proxyfy(final InitContext initContext, final Collection<Plugin> requiredPlugins, final Collection<Plugin> dependentPlugins) {
        return (InitContext)Proxy.newProxyInstance(initContext.getClass().getClassLoader(), new Class[]{InitContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("pluginsRequired")) {
                    return requiredPlugins;
                }
                if (method.getName().equals("dependentPlugins")) {
                    return dependentPlugins;
                }
                return method.invoke((Object)initContext, args);
            }
        });
    }

    void createDependencyInjectionProvidersMap(Collection<Class<?>> dependencyInjectionProvidersClasses) {
        this.dependencyInjectionProviders = new HashSet<DependencyInjectionProvider>();
        for (Class<?> dependencyInjectionProviderClass : dependencyInjectionProvidersClasses) {
            DependencyInjectionProvider injectionDependencyProvider = (DependencyInjectionProvider)this.newInstance(dependencyInjectionProviderClass);
            if (injectionDependencyProvider != null) {
                this.dependencyInjectionProviders.add(injectionDependencyProvider);
                continue;
            }
            throw new KernelException("DependencyInjectionProvider %s can not be instanciated", dependencyInjectionProviderClass);
        }
    }

    @Deprecated
    public static synchronized KernelBuilderWithPluginAndContext createKernel(String ... keyValues) {
        return new KernelBuilderImpl(keyValues);
    }

    private <T> T newInstance(Class<?> klass) {
        T instance = null;
        try {
            instance = (T)klass.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.error("Error when instantiating class " + klass, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Error when instantiating class " + klass, (Throwable)e);
        }
        return instance;
    }

    void addContainerContext(Object containerContext) {
        this.containerContext = containerContext;
    }

    void spiPluginEnabled() {
        this.spiPluginEnabled = true;
    }

    void spiPluginDisabled() {
        this.spiPluginEnabled = false;
    }

    void dependencyInjectionMode(DependencyInjectionMode dependencyInjectionMode) {
        this.dependencyInjectionMode = dependencyInjectionMode;
    }

    void classpathScanMode(ClasspathScanMode classpathScanMode) {
        this.classpathScanMode = classpathScanMode;
        this.initContext.classpathScanMode(classpathScanMode);
    }

    void addPlugins(Class<? extends Plugin> ... klass) {
        for (Class<? extends Plugin> class1 : klass) {
            Plugin plugin = (Plugin)this.newInstance(class1);
            if (plugin == null) {
                throw new KernelException("Plugin %s can not be instanciated", new Object[]{klass});
            }
            this.addPlugin(plugin);
        }
    }

    void addPlugins(Plugin ... plugins) {
        for (Plugin plugin : plugins) {
            this.addPlugin(plugin);
        }
    }

    void addPlugin(Plugin plugin) {
        if (this.started) {
            throw new KernelException("Plugin %s can not be added. Kernel already is started", plugin.name());
        }
        this.pluginsToAdd.put(plugin.name(), plugin);
    }

    AliasMap paramsAndAlias() {
        return this.kernelParamsAndAlias;
    }

    void provideGlobalDiDefValidation(ModuleValidation validation) {
        this.globalModuleValidations.add(validation);
    }

    private static class KernelBuilderImpl
    implements KernelBuilderWithPluginAndContext {
        private KernelCore kernel;

        public KernelBuilderImpl(String ... keyValues) {
        }

        @Override
        public Kernel build() {
            return null;
        }

        @Override
        public KernelBuilderWithPlugins withContainerContext(Object containerContext) {
            this.kernel.addContainerContext(containerContext);
            return this;
        }

        @Override
        public KernelBuilderWithPluginAndContext withPlugins(Class<? extends Plugin> ... klass) {
            this.kernel.addPlugins(klass);
            return this;
        }

        @Override
        public KernelBuilderWithPluginAndContext withPlugins(Plugin ... plugin) {
            this.kernel.addPlugins(plugin);
            return this;
        }

        @Override
        public KernelBuilderWithPluginAndContext withoutSpiPluginsLoader() {
            this.kernel.spiPluginDisabled();
            return this;
        }

        @Override
        public KernelBuilderWithPluginAndContext withDependencyInjectionMode(DependencyInjectionMode dependencyInjectionMode) {
            this.kernel.dependencyInjectionMode(dependencyInjectionMode);
            return this;
        }

        @Override
        public KernelBuilderWithPluginAndContext withClasspathScanMode(ClasspathScanMode classpathScanMode, Object scanConfigurationObject) {
            this.kernel.classpathScanMode(classpathScanMode);
            return this;
        }
    }

    private class ObjectGraphEmbedded
    implements ObjectGraph {
        private Object injector;

        public ObjectGraphEmbedded(Object injector) {
            this.injector = injector;
        }

        public Object get() {
            return this.injector;
        }

        public <T> T as(Class<T> targetType) {
            if (targetType.equals(Injector.class)) {
                return Injector.class.cast(this.injector);
            }
            throw new IllegalStateException("Can not cast " + this.injector + " to " + targetType.getName());
        }
    }

    public static interface KernelBuilderWithPlugins
    extends KernelBuilder {
        public KernelBuilderWithPluginAndContext withPlugins(Class<? extends Plugin> ... var1);

        public KernelBuilderWithPluginAndContext withPlugins(Plugin ... var1);

        public KernelBuilderWithPluginAndContext withoutSpiPluginsLoader();
    }

    public static interface KernelBuilderWithContainerContext
    extends KernelBuilder {
        public KernelBuilderWithPlugins withContainerContext(Object var1);
    }

    public static interface KernelModeContext
    extends KernelBuilder {
        public KernelBuilderWithPluginAndContext withDependencyInjectionMode(DependencyInjectionMode var1);

        public KernelBuilderWithPluginAndContext withClasspathScanMode(ClasspathScanMode var1, Object var2);
    }

    public static interface KernelBuilderWithPluginAndContext
    extends KernelBuilderWithContainerContext,
    KernelBuilderWithPlugins,
    KernelModeContext {
    }

    public static interface KernelBuilder {
        public Kernel build();
    }
}

