/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.api.config.DependencyInjectionMode;
import io.nuun.kernel.api.config.KernelConfiguration;
import io.nuun.kernel.api.di.ModuleValidation;
import io.nuun.kernel.core.internal.AliasMap;
import io.nuun.kernel.core.internal.KernelCore;
import io.nuun.kernel.core.internal.KernelCoreMutator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelConfigurationInternal
implements KernelConfiguration,
KernelCoreMutator {
    private final Logger logger;
    List<String> parameters = new ArrayList<String>();
    private Object containerContext;
    private Class<? extends Plugin>[] pluginsClass = new Class[0];
    private Plugin[] plugins = new Plugin[0];
    private boolean useSpi = true;
    private DependencyInjectionMode dependencyInjectionMode;
    private ClasspathScanMode classpathScanMode = ClasspathScanMode.NOMINAL;
    private List<ModuleValidation> validations = new ArrayList<ModuleValidation>();

    public KernelConfigurationInternal() {
        this.logger = LoggerFactory.getLogger(KernelConfiguration.class);
    }

    public KernelConfiguration param(String key, String value) {
        this.cleanParamsSize();
        this.parameters.add(key);
        this.parameters.add(value);
        return this;
    }

    private void cleanParamsSize() {
        if (this.parameters.size() % 2 != 0) {
            this.parameters.add("");
        }
    }

    public KernelConfiguration params(String ... paramEntries) {
        this.cleanParamsSize();
        for (String entry : paramEntries) {
            this.parameters.add(entry);
        }
        return this;
    }

    public KernelConfiguration containerContext(Object containerContext) {
        this.containerContext = containerContext;
        return this;
    }

    public KernelConfiguration plugins(Class<? extends Plugin> ... pluginsClass) {
        this.pluginsClass = this.concat(this.pluginsClass, pluginsClass);
        return this;
    }

    public KernelConfiguration plugins(Plugin ... plugins) {
        this.plugins = this.concat(this.plugins, plugins);
        return this;
    }

    public KernelConfiguration withoutSpiPluginsLoader() {
        this.useSpi = false;
        return this;
    }

    public KernelConfiguration withSpiPluginsLoader() {
        this.useSpi = true;
        return this;
    }

    public KernelConfiguration dependencyInjectionMode(DependencyInjectionMode dependencyInjectionMode) {
        this.dependencyInjectionMode = dependencyInjectionMode;
        return this;
    }

    public KernelConfiguration classpathScanMode(ClasspathScanMode classpathScanMode) {
        this.classpathScanMode = classpathScanMode;
        return this;
    }

    public KernelConfiguration moduleValidation(ModuleValidation validation) {
        if (validation != null) {
            this.validations.add(validation);
        }
        return this;
    }

    @Override
    public void apply(KernelCore kernelCore) {
        AliasMap kernelParamsAndAlias = kernelCore.paramsAndAlias();
        Iterator<String> it = this.parameters.iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = "";
            if (it.hasNext()) {
                value = it.next();
            }
            this.logger.info("Adding {} = {} as param to kernel", (Object)key, (Object)value);
            kernelParamsAndAlias.put(key, value);
        }
        kernelCore.addContainerContext(this.containerContext);
        kernelCore.addPlugins(this.pluginsClass);
        kernelCore.addPlugins(this.plugins);
        if (this.useSpi) {
            kernelCore.spiPluginEnabled();
        } else {
            kernelCore.spiPluginDisabled();
        }
        kernelCore.dependencyInjectionMode(this.dependencyInjectionMode);
        kernelCore.classpathScanMode(this.classpathScanMode);
        for (ModuleValidation validation : this.validations) {
            kernelCore.provideGlobalDiDefValidation(validation);
        }
    }

    private <T> T[] concat(T[] A, T[] B) {
        int aLen = A.length;
        int bLen = B.length;
        Object[] C = (Object[])Array.newInstance(A.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }
}

