/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AliasMap
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    Map<String, String> aliases = new HashMap<String, String>();

    public String putAlias(String key, String alias) {
        if (super.containsKey(alias)) {
            throw new IllegalArgumentException("alias " + alias + " already exists in map.");
        }
        return this.aliases.put(alias, key);
    }

    @Override
    public String get(Object key) {
        String keyAlias = this.aliases.get(key);
        if (keyAlias == null) {
            return (String)super.get(key);
        }
        return (String)super.get(keyAlias);
    }

    public boolean containsAllKeys(Collection<String> computedMandatoryParams) {
        HashSet<Object> allKeys = new HashSet<Object>();
        allKeys.addAll(this.keySet());
        allKeys.addAll(this.aliases.values());
        HashSet<String> trans = new HashSet<String>();
        for (String s : computedMandatoryParams) {
            String string = this.aliases.get(s);
            if (string == null) continue;
            trans.add(string);
        }
        return allKeys.containsAll(trans);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.aliases.containsKey(key) ? true : super.containsKey(key);
    }
}

