/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.RoundEnvironment;
import io.nuun.kernel.api.plugin.context.Context;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.BindingRequest;
import io.nuun.kernel.api.plugin.request.BindingRequestBuilder;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequestBuilder;
import io.nuun.kernel.api.plugin.request.KernelParamsRequest;
import io.nuun.kernel.api.plugin.request.KernelParamsRequestBuilder;
import io.nuun.kernel.api.plugin.request.builders.BindingRequestBuilderMain;
import io.nuun.kernel.core.internal.ModuleEmbedded;
import io.nuun.kernel.spi.DependencyInjectionProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kametic.specifications.AbstractSpecification;
import org.kametic.specifications.AndSpecification;
import org.kametic.specifications.NotSpecification;
import org.kametic.specifications.OrSpecification;
import org.kametic.specifications.Specification;
import org.kametic.specifications.reflect.ClassMethodsAnnotatedWith;
import org.kametic.specifications.reflect.DescendantOfSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlugin
implements Plugin {
    Logger logger = LoggerFactory.getLogger(AbstractPlugin.class);
    protected Context context = null;
    protected Object containerContext = null;
    protected RoundEnvironment roundEnvironment;
    private Map<String, String> kernelParams;
    private InitContext initContext;
    private final KernelParamsRequestBuilder paramsBuilder = new KernelParamsRequestBuilder();
    private final ClasspathScanRequestBuilder scanBuilder = new ClasspathScanRequestBuilder();
    private final BindingRequestBuilder bindingBuilder = new BindingRequestBuilder();

    public InitState init(InitContext initContext) {
        this.initContext = initContext;
        return InitState.INITIALIZED;
    }

    public void stop() {
    }

    public void start(Context context) {
        this.context = context;
    }

    public void destroy() {
    }

    protected KernelParamsRequestBuilder kernelParamsRequestBuilder() {
        this.paramsBuilder.reset();
        return this.paramsBuilder;
    }

    protected ClasspathScanRequestBuilder classpathScanRequestBuilder() {
        this.scanBuilder.reset();
        return this.scanBuilder;
    }

    protected BindingRequestBuilderMain bindingRequestsBuilder() {
        this.bindingBuilder.reset();
        return this.bindingBuilder;
    }

    protected Specification<Class<?>> or(Specification<Class<?>> ... participants) {
        return new OrSpecification(participants);
    }

    protected Specification<Class<?>> and(Specification<Class<?>> ... participants) {
        return new AndSpecification(participants);
    }

    protected Specification<Class<?>> not(Specification<Class<?>> participant) {
        return new NotSpecification(participant);
    }

    protected Specification<Class<?>> descendantOf(Class<?> ancestor) {
        return new DescendantOfSpecification(ancestor);
    }

    protected Specification<Class<?>> classMethodsAnnotatedWith(Class<? extends Annotation> annotationClass) {
        return new ClassMethodsAnnotatedWith(annotationClass);
    }

    protected Specification<Class<?>> fieldAnnotatedWith(final Class<? extends Annotation> annotationClass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                if (candidate != null) {
                    try {
                        for (Field field : candidate.getDeclaredFields()) {
                            if (!field.isAnnotationPresent(annotationClass)) continue;
                            return true;
                        }
                    }
                    catch (Throwable throwable) {
                        AbstractPlugin.this.logger.debug("fieldAnnotatedWith : " + candidate + " missing " + throwable);
                    }
                }
                return false;
            }
        };
    }

    protected Specification<Class<?>> classAnnotatedWith(final Class<? extends Annotation> klass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && candidate.getAnnotation(klass) != null;
            }
        };
    }

    protected Specification<Class<?>> classImplements(final Class<?> klass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                if (candidate != null && klass.isInterface()) {
                    for (Class<?> i : candidate.getInterfaces()) {
                        if (!i.equals(klass)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public abstract String name();

    public String description() {
        return this.name() + " Nuun Based Plugin.";
    }

    public Collection<KernelParamsRequest> kernelParamsRequests() {
        return Collections.emptySet();
    }

    public Collection<ClasspathScanRequest> classpathScanRequests() {
        return Collections.emptySet();
    }

    public Collection<BindingRequest> bindingRequests() {
        return Collections.emptySet();
    }

    public Collection<Class<? extends Plugin>> requiredPlugins() {
        return Collections.emptySet();
    }

    public Collection<Class<? extends Plugin>> dependentPlugins() {
        return Collections.emptySet();
    }

    public String pluginPropertiesPrefix() {
        return "";
    }

    public String pluginPackageRoot() {
        return "";
    }

    public UnitModule unitModule() {
        return this.nativeUnitModule() != null ? new ModuleEmbedded(this.nativeUnitModule()) : null;
    }

    public Object nativeUnitModule() {
        return null;
    }

    public Object nativeOverridingUnitModule() {
        return null;
    }

    public UnitModule overridingUnitModule() {
        return this.nativeOverridingUnitModule() != null ? new ModuleEmbedded(this.nativeOverridingUnitModule()) : null;
    }

    public void provideContainerContext(Object containerContext) {
        this.containerContext = containerContext;
    }

    public Set<URL> computeAdditionalClasspathScan() {
        return Collections.emptySet();
    }

    public DependencyInjectionProvider dependencyInjectionProvider() {
        return null;
    }

    public void provideRoundEnvironment(RoundEnvironment roundEnvironment) {
        this.roundEnvironment = roundEnvironment;
    }

    public Map<String, String> kernelParametersAliases() {
        return new HashMap<String, String>();
    }

    protected Collection<Class<? extends Plugin>> collectionOf(Class<? extends Plugin> ... items) {
        return Arrays.asList(items);
    }

    protected UnitModule unitModule(Object module) {
        return new ModuleEmbedded(module);
    }
}

