package io.nuov.util;

import io.nuov.validator.Nouns;
import io.nuov.validator.StringValidator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

/** The class FileUtils. */
public class FileUtils {

  /**
   * Loads the file located at path and returns it as an InputStream.
   *
   * @param path the path of the file
   * @return the input stream
   */
  public static InputStream getInputStream(final String path) {

    // validate
    StringValidator.the(Nouns.ARGUMENT, "path", path).validate();

    try {
      final File initialFile = new File(path);
      return new FileInputStream(initialFile);
    } catch (final IOException ioException) {
      throw new RuntimeException(ioException);
    }
  }

  /**
   * Loads the file located at path and returns it as a String.
   *
   * @param path the path of the file
   * @return the string
   */
  public static String getString(final String path) {
    try {
      final InputStream inputStream = FileUtils.getInputStream(path);
      return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    } catch (final IOException ioException) {
      throw new RuntimeException(ioException);
    }
  }
}
