package io.nuov.util;

import io.nuov.validator.Nouns;
import io.nuov.validator.ObjectValidator;
import io.nuov.validator.StringValidator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

/** The class ResourcesUtils. */
public class ResourcesUtils {

  /**
   * Loads a file in src/main/resources folder and returns it as an InputStream.
   *
   * @param path the path of the file (relative to src/main/resources)
   * @return the input stream
   */
  public static InputStream getInputStream(final String path) {

    // validate
    StringValidator.the(Nouns.ARGUMENT, "path", path).validate();

    // input stream
    final InputStream inputStream = ResourcesUtils.class.getResourceAsStream(path);

    // validate
    ObjectValidator.the(Nouns.VARIABLE, "inputStream", inputStream).validate();

    return inputStream;
  }

  /**
   * Loads a file in src/main/resources folder and returns it as a String.
   *
   * @param path the path of the file (relative to src/main/resources)
   * @return the file as a String
   */
  public static String getString(final String path) {
    try {
      final InputStream inputStream = ResourcesUtils.getInputStream(path);
      return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    } catch (final IOException ioException) {
      throw new RuntimeException(ioException);
    }
  }
}
