/*
 * Decompiled with CFR 0.152.
 */
package io.nuov.spring.error;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

class ExceptionResponseEntity
extends ResponseEntity<Object> {
    public ExceptionResponseEntity(String message, HttpStatus httpStatus) {
        super((Object)new ExceptionResponse(message, httpStatus), (HttpStatusCode)httpStatus);
    }

    public ExceptionResponseEntity(Exception exception, HttpStatus httpStatus) {
        super((Object)new ExceptionResponse(exception, httpStatus), (HttpStatusCode)httpStatus);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class ExceptionResponse {
        private final HttpStatus httpStatus;
        private final String message;
        private final Date timestamp;

        ExceptionResponse(String message, HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            this.message = message;
            this.timestamp = new Date();
        }

        ExceptionResponse(Exception exception, HttpStatus httpStatus) {
            this.message = exception.getMessage();
            this.httpStatus = httpStatus;
            this.timestamp = new Date();
        }

        public HttpStatus getHttpStatus() {
            return this.httpStatus;
        }

        public int getStatus() {
            return this.httpStatus.value();
        }

        public String getError() {
            return this.httpStatus.getReasonPhrase();
        }

        public String getMessage() {
            return this.message;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }
}

