/*
 * Decompiled with CFR 0.152.
 */
package io.nuov.spring.error;

import io.nuov.error.BadRequestException;
import io.nuov.error.ForbiddenException;
import io.nuov.error.LockedException;
import io.nuov.error.NotFoundException;
import io.nuov.error.NotModifiedException;
import io.nuov.error.ServiceUnavailableException;
import io.nuov.error.UnauthorizedException;
import io.nuov.logging.LoggingDependency;
import io.nuov.spring.error.ExceptionResponseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

public abstract class AbstractResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler
implements LoggingDependency {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Logger getLogger() {
        return this.logger;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleAll(Exception exception, WebRequest webRequest) {
        this.logException(exception, webRequest);
        this.reportException(exception, webRequest);
        return new ExceptionResponseEntity("An internal service error has occurred.", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BadRequestException.class})
    protected ResponseEntity<Object> handleBadRequest(BadRequestException badRequestException) {
        return new ExceptionResponseEntity((Exception)badRequestException, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ForbiddenException.class})
    protected ResponseEntity<Object> handleForbidden(ForbiddenException forbiddenException) {
        return new ExceptionResponseEntity((Exception)forbiddenException, HttpStatus.FORBIDDEN);
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException httpMediaTypeNotSupportedException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        String message = String.valueOf(httpMediaTypeNotSupportedException.getContentType()) + " media type is not supported.";
        return new ExceptionResponseEntity(message, HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        String message = "Malformed JSON request";
        return new ExceptionResponseEntity("Malformed JSON request", HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException httpMessageNotWritableException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        String message = "Error writing JSON output";
        return new ExceptionResponseEntity("Error writing JSON output", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException httpRequestMethodNotSupportedException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        String message = "This request is not supported.";
        return new ExceptionResponseEntity("This request is not supported.", HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={LockedException.class})
    protected ResponseEntity<Object> handleLocked(LockedException lockedException) {
        return new ExceptionResponseEntity((Exception)lockedException, HttpStatus.LOCKED);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        String message = missingServletRequestParameterException.getParameterName() + " parameter is missing";
        return new ExceptionResponseEntity(message, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<Object> handleNoHandlerFoundException(NoHandlerFoundException noHandlerFoundException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        String message = String.format("Could not find the %s method for URL %s", noHandlerFoundException.getHttpMethod(), noHandlerFoundException.getRequestURL());
        return new ExceptionResponseEntity(message, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotFoundException.class})
    protected ResponseEntity<Object> handleNotFound(NotFoundException notFoundException) {
        return new ExceptionResponseEntity((Exception)notFoundException, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={NotModifiedException.class})
    protected ResponseEntity<Object> handleNotModified(NotModifiedException notModifiedException) {
        return new ExceptionResponseEntity((Exception)notModifiedException, HttpStatus.NOT_MODIFIED);
    }

    @ExceptionHandler(value={ServiceUnavailableException.class})
    protected ResponseEntity<Object> handleServiceUnavailable(ServiceUnavailableException serviceUnavailableException) {
        return new ExceptionResponseEntity((Exception)serviceUnavailableException, HttpStatus.SERVICE_UNAVAILABLE);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    protected ResponseEntity<Object> handleUnauthorized(UnauthorizedException unauthorizedException) {
        return new ExceptionResponseEntity((Exception)unauthorizedException, HttpStatus.UNAUTHORIZED);
    }

    protected void logException(Exception exception, WebRequest webRequest) {
        this.getLogger().error(exception.getMessage(), (Throwable)exception);
    }

    protected abstract void reportException(Exception var1, WebRequest var2);
}

