package io.nuov.spring.error;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

/** The class ExceptionResponseEntity. */
class ExceptionResponseEntity extends ResponseEntity<Object> {

  /** The class ExceptionResponse. */
  @JsonInclude(JsonInclude.Include.NON_NULL)
  static class ExceptionResponse {

    /** The http status. */
    private final HttpStatus httpStatus;

    /** The message. */
    private final String message;

    /** The time stamp. */
    private final Date timestamp;

    /**
     * Instantiates an ExceptionResponse
     *
     * @param httpStatus the http status
     * @param message the message
     */
    ExceptionResponse(final String message, final HttpStatus httpStatus) {
      this.httpStatus = httpStatus;
      this.message = message;
      timestamp = new Date();
    }

    /**
     * Instantiates an ExceptionResponse
     *
     * @param exception the exception
     * @param httpStatus the http status
     */
    ExceptionResponse(final Exception exception, final HttpStatus httpStatus) {
      this.message = exception.getMessage();
      this.httpStatus = httpStatus;
      timestamp = new Date();
    }

    /**
     * Get the http status.
     *
     * @return the http status
     */
    @SuppressWarnings("unused")
    public HttpStatus getHttpStatus() {
      return this.httpStatus;
    }

    /**
     * Get the status.
     *
     * @return the status
     */
    @SuppressWarnings("unused")
    public int getStatus() {
      return this.httpStatus.value();
    }

    /**
     * Get the error.
     *
     * @return the error
     */
    @SuppressWarnings("unused")
    public String getError() {
      return this.httpStatus.getReasonPhrase();
    }

    /**
     * Get the message.
     *
     * @return the message
     */
    @SuppressWarnings("unused")
    public String getMessage() {
      return this.message;
    }

    /**
     * Get the timestamp.
     *
     * @return the status
     */
    @SuppressWarnings("unused")
    public Date getTimestamp() {
      return this.timestamp;
    }
  }

  /**
   * Instantiates an ExceptionResponseEntity
   *
   * @param message the message
   * @param httpStatus the http status
   */
  public ExceptionResponseEntity(final String message, final HttpStatus httpStatus) {
    super(new ExceptionResponse(message, httpStatus), httpStatus);
  }

  /**
   * Instantiates an ExceptionResponseEntity
   *
   * @param exception the exception
   * @param httpStatus the http status
   */
  public ExceptionResponseEntity(final Exception exception, final HttpStatus httpStatus) {
    super(new ExceptionResponse(exception, httpStatus), httpStatus);
  }
}
