/*
 * Decompiled with CFR 0.152.
 */
package io.nuov.firebase.authentication;

import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.EmailIdentifier;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.GetUsersResult;
import com.google.firebase.auth.UserRecord;
import io.nuov.firebase.initializer.FirebaseInitializer;
import io.nuov.validator.EmailValidator;
import io.nuov.validator.Noun;
import io.nuov.validator.Nouns;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

public class FirebaseAuthentication {
    public FirebaseAuthentication() {
        FirebaseInitializer.initialize();
    }

    public String addUser(String email) {
        UserRecord userRecord;
        EmailValidator.the((Noun)Nouns.ARGUMENT, (String)"email", (String)email).validate();
        UserRecord.CreateRequest createRequest = new UserRecord.CreateRequest().setEmail(email).setEmailVerified(false).setPassword(UUID.randomUUID().toString()).setDisabled(false);
        try {
            userRecord = FirebaseAuth.getInstance().createUser(createRequest);
        }
        catch (FirebaseAuthException firebaseAuthException) {
            throw new RuntimeException(firebaseAuthException);
        }
        return userRecord.getUid();
    }

    public String getPasswordResetLink(String email, String url) {
        EmailValidator.the((Noun)Nouns.ARGUMENT, (String)"email", (String)email).validate();
        ActionCodeSettings actionCodeSettings = ActionCodeSettings.builder().setUrl(url).build();
        try {
            return FirebaseAuth.getInstance().generatePasswordResetLink(email, actionCodeSettings);
        }
        catch (FirebaseAuthException firebaseAuthException) {
            throw new RuntimeException(firebaseAuthException);
        }
    }

    public String getUid(String email) {
        EmailValidator.the((Noun)Nouns.ARGUMENT, (String)"email", (String)email).validate();
        try {
            UserRecord userRecord = FirebaseAuth.getInstance().getUserByEmail(email);
            return userRecord.getUid();
        }
        catch (FirebaseAuthException firebaseAuthException) {
            throw new RuntimeException(firebaseAuthException);
        }
    }

    public boolean userExists(String email) {
        EmailValidator.the((Noun)Nouns.ARGUMENT, (String)"email", (String)email).validate();
        try {
            GetUsersResult getUsersResult = (GetUsersResult)FirebaseAuth.getInstance().getUsersAsync(List.of(new EmailIdentifier(email))).get();
            return getUsersResult.getUsers().size() == 1;
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException(exception);
        }
    }
}

