/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed.equations;

import io.noties.tumbleweed.TweenEquation;

public enum Sine implements TweenEquation
{
    IN{

        @Override
        public float compute(float t) {
            return (float)(-Math.cos(t * 1.5707964f)) + 1.0f;
        }
    }
    ,
    OUT{

        @Override
        public float compute(float t) {
            return (float)Math.sin(t * 1.5707964f);
        }
    }
    ,
    INOUT{

        @Override
        public float compute(float t) {
            return -0.5f * ((float)Math.cos((float)Math.PI * t) - 1.0f);
        }
    };

    private static final float PI = (float)Math.PI;

    public String toString() {
        return "Sine." + this.name();
    }
}

