/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed.equations;

import io.noties.tumbleweed.TweenEquation;

public enum Elastic implements TweenEquation
{
    IN{

        @Override
        public float compute(float t) {
            float a = 1.0f;
            float p = 0.3f;
            if (t == 0.0f) {
                return 0.0f;
            }
            if (t == 1.0f) {
                return 1.0f;
            }
            float s = p / 4.0f;
            return -(a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t - s) * ((float)Math.PI * 2) / p));
        }
    }
    ,
    OUT{

        @Override
        public float compute(float t) {
            float a = 1.0f;
            float p = 0.3f;
            if (t == 0.0f) {
                return 0.0f;
            }
            if (t == 1.0f) {
                return 1.0f;
            }
            float s = p / 4.0f;
            return a * (float)Math.pow(2.0, -10.0f * t) * (float)Math.sin((t - s) * ((float)Math.PI * 2) / p) + 1.0f;
        }
    }
    ,
    INOUT{

        @Override
        public float compute(float t) {
            float a = 1.0f;
            float p = 0.45000002f;
            if (t == 0.0f) {
                return 0.0f;
            }
            if ((t *= 2.0f) == 2.0f) {
                return 1.0f;
            }
            float s = p / 4.0f;
            if (t < 1.0f) {
                return -0.5f * (a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t - s) * ((float)Math.PI * 2) / p));
            }
            return a * (float)Math.pow(2.0, -10.0f * (t -= 1.0f)) * (float)Math.sin((t - s) * ((float)Math.PI * 2) / p) * 0.5f + 1.0f;
        }
    };

    private static final float PI = (float)Math.PI;
    private static final float param_a = 1.0f;
    private static final float param_p = 0.3f;

    public String toString() {
        return "Elastic." + this.name();
    }
}

