/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import io.noties.tumbleweed.BaseTween;
import io.noties.tumbleweed.TweenManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TweenManagerImpl
extends TweenManager {
    private final List<BaseTween> children = new ArrayList<BaseTween>(8);
    private boolean isPaused;
    private boolean isDisposed;
    protected boolean isStarted;

    @Override
    @NonNull
    public TweenManager add(@NonNull BaseTween object) {
        if (this.isDisposed()) {
            throw new RuntimeException("Cannot add tween to a disposed TweenManager");
        }
        if (!this.children.contains(object)) {
            this.children.add(object);
        }
        if (object.autoStartEnabled()) {
            object.start();
        }
        if (!this.isStarted) {
            this.onStarted();
        }
        return this;
    }

    @Override
    public boolean containsTarget(@NonNull Object target) {
        boolean result = false;
        for (BaseTween tween : this.children) {
            if (!tween.containsTarget(target)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void killAll() {
        for (BaseTween tween : this.children) {
            tween.kill();
        }
    }

    @Override
    public void killTarget(@NonNull Object target) {
        for (BaseTween tween : this.children) {
            tween.killTarget(target);
        }
    }

    @Override
    public void pause() {
        if (this.isDisposed()) {
            throw new RuntimeException("Cannot pause disposed TweenManager");
        }
        this.isPaused = true;
        if (this.isStarted) {
            this.onStopped();
        }
    }

    @Override
    public void resume() {
        if (this.isDisposed()) {
            throw new RuntimeException("Cannot resume disposed TweenManager");
        }
        this.isPaused = false;
        if (this.children.size() > 0) {
            this.onStarted();
        }
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public boolean isRunning() {
        return this.isStarted && !this.isPaused;
    }

    @Override
    public void update(float delta) {
        block5: {
            this.clearFinished();
            if (this.children.size() == 0) {
                this.onStopped();
                return;
            }
            if (this.isPaused) break block5;
            if (delta >= 0.0f) {
                int size = this.children.size();
                for (int i = 0; i < size; ++i) {
                    this.children.get(i).update(delta);
                }
            } else {
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    this.children.get(i).update(delta);
                }
            }
        }
    }

    @Override
    @CallSuper
    public void dispose() {
        if (!this.isDisposed) {
            this.onStopped();
            this.killAll();
            this.children.clear();
            this.isDisposed = true;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public int tweenCount() {
        return this.children.size();
    }

    @Override
    @NonNull
    public List<BaseTween> tweens() {
        List<BaseTween> tweens = this.children.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(this.children);
        return tweens;
    }

    private void clearFinished() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            BaseTween baseTween = this.children.get(i);
            if (!baseTween.isFinished() || !baseTween.autoRemoveEnabled()) continue;
            this.children.remove(i);
        }
    }

    @CallSuper
    protected void onStarted() {
        this.isStarted = true;
    }

    @CallSuper
    protected void onStopped() {
        this.isStarted = false;
    }
}

