/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed;

import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.noties.tumbleweed.BaseTweenDefImpl;
import io.noties.tumbleweed.Tween;
import io.noties.tumbleweed.TweenAction;
import io.noties.tumbleweed.TweenCallback;
import io.noties.tumbleweed.TweenDef;
import io.noties.tumbleweed.TweenEquation;
import io.noties.tumbleweed.TweenManager;
import io.noties.tumbleweed.TweenPath;
import io.noties.tumbleweed.TweenType;

class TweenDefImpl<T>
extends TweenDef<T> {
    final boolean isFrom;
    final T target;
    final TweenType<T> tweenType;
    final BaseTweenDefImpl impl;
    final int targetSize;
    TweenEquation equation;
    TweenPath path;
    float[] targets;
    float[] waypoints;
    private float[] scale;
    TweenAction<T> action;
    private int waypointsCount;
    private boolean isBuilt;

    TweenDefImpl(boolean from, @Nullable T target, @Nullable TweenType<T> tweenType, @FloatRange(from=0.0) float duration) {
        this.isFrom = from;
        this.target = target;
        this.tweenType = tweenType;
        this.impl = new BaseTweenDefImpl().setDuration(duration);
        int targetSize = tweenType != null ? tweenType.getValuesSize() : 0;
        this.targetSize = targetSize;
    }

    @Override
    @NonNull
    public TweenDef<T> duration(float duration) {
        this.checkState();
        this.impl.setDuration(duration);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> ease(@NonNull TweenEquation equation) {
        this.checkState();
        this.equation = equation;
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> path(@NonNull TweenPath path) {
        this.checkState();
        this.path = path;
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> target(@NonNull T target) {
        float[] values = new float[this.tweenType.getValuesSize()];
        this.tweenType.getValues(target, values);
        this.target(values);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> target(float ... targets) {
        this.checkState();
        this.validateTargetSize(targets.length);
        this.targets = targets;
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> waypoint(@NonNull T target) {
        float[] waypoint = new float[this.tweenType.getValuesSize()];
        this.tweenType.getValues(target, waypoint);
        this.waypoint(waypoint);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> waypoint(float ... waypoints) {
        this.checkState();
        this.validateTargetSize(waypoints.length);
        this.ensureWaypoints((this.waypointsCount + 1) * this.targetSize);
        System.arraycopy(waypoints, 0, this.waypoints, this.waypointsCount * this.targetSize, this.targetSize);
        ++this.waypointsCount;
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> scale(float ... targets) {
        this.checkState();
        this.scale = targets;
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> action(@NonNull TweenAction<T> action) {
        this.action = action;
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> delay(float duration) {
        this.checkState();
        this.impl.delay(duration);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> repeat(int count, float delay) {
        this.checkState();
        this.impl.repeat(count, delay);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> repeatYoyo(int count, float delay) {
        this.checkState();
        this.impl.repeatYoyo(count, delay);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> addCallback(@NonNull TweenCallback callback) {
        this.checkState();
        this.impl.addCallback(callback);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> addCallback(@TweenCallback.Event int callbackEvents, @NonNull TweenCallback callback) {
        this.checkState();
        this.impl.addCallback(callbackEvents, callback);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> userData(Object userData) {
        this.checkState();
        this.impl.userData(userData);
        return this;
    }

    @Override
    @NonNull
    public TweenDef<T> removeWhenFinished(boolean removeWhenFinished) {
        this.checkState();
        this.impl.removeWhenFinished(removeWhenFinished);
        return this;
    }

    @Override
    public int repeatCount() {
        return this.impl.repeatCount;
    }

    @Override
    public float delay() {
        return this.impl.delay;
    }

    @Override
    public float fullDuration() {
        return this.impl.fullDuration();
    }

    @Override
    @NonNull
    public Tween build() {
        int scaleSize;
        this.checkState();
        this.isBuilt = true;
        int n = scaleSize = this.scale != null ? this.scale.length : 0;
        if (this.targetSize > 0 && scaleSize > 0) {
            for (int i = 0; i < this.targetSize; ++i) {
                this.targets[i] = this.targets[i] * this.scale[i % scaleSize];
            }
        }
        return new Tween(this);
    }

    @Override
    @NonNull
    public Tween start() {
        Tween tween = this.build();
        tween.start();
        return tween;
    }

    @Override
    @NonNull
    public Tween start(@NonNull TweenManager manager) {
        Tween tween = this.build();
        tween.start(manager);
        return tween;
    }

    private void validateTargetSize(int actual) {
        if (actual != this.targetSize) {
            throw new RuntimeException("Target size mismatch. Expected: " + this.targetSize + ", actual: " + actual);
        }
    }

    private void ensureWaypoints(int newLength) {
        if (this.waypoints == null) {
            this.waypoints = new float[newLength];
        } else if (newLength > this.waypoints.length) {
            float[] cache = this.waypoints;
            this.waypoints = new float[newLength];
            System.arraycopy(cache, 0, this.waypoints, 0, cache.length);
        }
    }

    private void checkState() {
        if (this.isBuilt) {
            throw new RuntimeException("TweenDef has already been built.");
        }
    }
}

