/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed;

import android.support.annotation.NonNull;
import io.noties.tumbleweed.BaseTween;
import io.noties.tumbleweed.TweenCallback;
import java.util.ArrayList;
import java.util.List;

abstract class TweenCallbacks {
    private static final TweenCallbacks NO_OP = new TweenCallbacks(){

        @Override
        void call(int type, @NonNull BaseTween source) {
        }
    };

    TweenCallbacks() {
    }

    abstract void call(int var1, @NonNull BaseTween var2);

    private static class Impl
    extends TweenCallbacks {
        private final List<Pair> list;

        private Impl(@NonNull List<Pair> list) {
            this.list = list;
        }

        @Override
        void call(int type, @NonNull BaseTween source) {
            for (Pair pair : this.list) {
                if ((pair.type & type) <= 0) continue;
                pair.callback.onEvent(type, source);
            }
        }
    }

    private static class Pair {
        final int type;
        final TweenCallback callback;

        Pair(int type, @NonNull TweenCallback callback) {
            this.type = type;
            this.callback = callback;
        }
    }

    static class Builder {
        private final List<Pair> list = new ArrayList<Pair>(3);

        Builder() {
        }

        @NonNull
        Builder add(@NonNull TweenCallback callback) {
            this.list.add(new Pair(255, callback));
            return this;
        }

        @NonNull
        Builder add(int type, @NonNull TweenCallback callback) {
            this.list.add(new Pair(type, callback));
            return this;
        }

        @NonNull
        TweenCallbacks build() {
            TweenCallbacks callbacks = this.list.size() == 0 ? NO_OP : new Impl(this.list);
            return callbacks;
        }
    }
}

