/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.noties.tumbleweed.BaseTween;
import io.noties.tumbleweed.TweenAction;
import io.noties.tumbleweed.TweenCallback;
import io.noties.tumbleweed.TweenDef;
import io.noties.tumbleweed.TweenDefImpl;
import io.noties.tumbleweed.TweenEquation;
import io.noties.tumbleweed.TweenManager;
import io.noties.tumbleweed.TweenPath;
import io.noties.tumbleweed.TweenType;
import io.noties.tumbleweed.equations.Quad;
import io.noties.tumbleweed.paths.CatmullRom;

public final class Tween
extends BaseTween {
    public static final int INFINITY = -1;
    private final Object target;
    private final TweenType<Object> tweenType;
    private final TweenEquation equation;
    private final TweenPath path;
    private final TweenAction<Object> tweenAction;
    private final boolean isFrom;
    private final int combinedAttrsCount;
    private final int waypointsCount;
    private final float[] startValues;
    private final float[] targetValues;
    private final float[] waypoints;
    private final float[] accessorBuffer;
    private final float[] pathBuffer;

    @NonNull
    public static <T> TweenDef<T> to(@NonNull T target, @NonNull TweenType<T> tweenType) {
        return Tween.to(target, tweenType, 0.0f);
    }

    @NonNull
    public static <T> TweenDef<T> to(@NonNull T target, @NonNull TweenType<T> tweenType, float duration) {
        return new TweenDefImpl<T>(false, target, tweenType, duration).ease(Quad.INOUT).path(CatmullRom.instance());
    }

    @NonNull
    public static <T> TweenDef<T> from(@NonNull T target, @NonNull TweenType<T> tweenType) {
        return Tween.from(target, tweenType, 0.0f);
    }

    @NonNull
    public static <T> TweenDef<T> from(@NonNull T target, @NonNull TweenType<T> tweenType, float duration) {
        return new TweenDefImpl<T>(true, target, tweenType, duration).ease(Quad.INOUT).path(CatmullRom.instance());
    }

    @NonNull
    public static <T> TweenDef<T> set(@NonNull T target, @NonNull TweenType<T> tweenType) {
        return new TweenDefImpl<T>(false, target, tweenType, 0.0f).ease(Quad.INOUT);
    }

    @NonNull
    public static TweenDef call(@NonNull TweenCallback callback) {
        return new TweenDefImpl<Object>(false, null, null, 0.0f).addCallback(2, callback);
    }

    @NonNull
    public static TweenDef mark() {
        return new TweenDefImpl<Object>(false, null, null, 0.0f);
    }

    @Override
    @NonNull
    public Tween start() {
        super.start();
        return this;
    }

    @Override
    @NonNull
    public Tween start(@NonNull TweenManager manager) {
        super.start(manager);
        return this;
    }

    Tween(@NonNull TweenDefImpl def) {
        super(def.impl);
        this.target = def.target;
        this.tweenType = def.tweenType;
        this.equation = def.equation;
        this.path = def.path;
        this.tweenAction = def.action;
        this.isFrom = def.isFrom;
        this.combinedAttrsCount = def.targetSize;
        this.startValues = new float[this.combinedAttrsCount];
        this.targetValues = def.targets;
        this.waypoints = def.waypoints;
        this.waypointsCount = this.waypoints != null ? this.waypoints.length / this.combinedAttrsCount : 0;
        this.accessorBuffer = new float[this.combinedAttrsCount];
        this.pathBuffer = this.waypointsCount > 0 ? new float[(2 + this.waypointsCount) * this.combinedAttrsCount] : null;
    }

    @Nullable
    public Object getTarget() {
        return this.target;
    }

    @Override
    protected void initializeOverride() {
        if (this.target == null) {
            return;
        }
        this.tweenType.getValues(this.target, this.startValues);
        for (int i = 0; i < this.combinedAttrsCount; ++i) {
            if (!this.isFrom) continue;
            float tmp = this.startValues[i];
            this.startValues[i] = this.targetValues[i];
            this.targetValues[i] = tmp;
        }
    }

    @Override
    protected void updateOverride(int step, int lastStep, boolean isIterationStep, float delta) {
        if (this.target == null || this.equation == null) {
            return;
        }
        if (!isIterationStep && step > lastStep) {
            this.setValues(this.isReverse(lastStep) ? this.startValues : this.targetValues);
            return;
        }
        if (!isIterationStep && step < lastStep) {
            this.setValues(this.isReverse(lastStep) ? this.targetValues : this.startValues);
            return;
        }
        if (!isIterationStep) {
            throw new IllegalStateException("Assertion failed, isIterationStep");
        }
        float currentTime = this.getCurrentTime();
        if (!(currentTime >= 0.0f)) {
            throw new IllegalStateException("Assertion failed, currentTime >= 0");
        }
        if (!(currentTime <= this.duration)) {
            throw new IllegalStateException("Assertion failed, currentTime <= duration");
        }
        if (this.duration < 1.0E-11f && delta > -1.0E-11f) {
            this.setValues(this.isReverse(step) ? this.targetValues : this.startValues);
            return;
        }
        if (this.duration < 1.0E-11f && delta < 1.0E-11f) {
            this.setValues(this.isReverse(step) ? this.startValues : this.targetValues);
            return;
        }
        float time = this.isReverse(step) ? this.duration - currentTime : currentTime;
        float t = this.equation.compute(time / this.duration);
        if (this.waypointsCount == 0 || this.path == null) {
            for (int i = 0; i < this.combinedAttrsCount; ++i) {
                this.accessorBuffer[i] = this.startValues[i] + t * (this.targetValues[i] - this.startValues[i]);
            }
        } else {
            for (int i = 0; i < this.combinedAttrsCount; ++i) {
                this.pathBuffer[0] = this.startValues[i];
                this.pathBuffer[1 + this.waypointsCount] = this.targetValues[i];
                for (int ii = 0; ii < this.waypointsCount; ++ii) {
                    this.pathBuffer[ii + 1] = this.waypoints[ii * this.combinedAttrsCount + i];
                }
                this.accessorBuffer[i] = this.path.compute(t, this.pathBuffer, this.waypointsCount + 2);
            }
        }
        this.setValues(this.accessorBuffer);
    }

    @Override
    protected void forceStartValues() {
        if (this.target != null) {
            this.setValues(this.startValues);
        }
    }

    @Override
    protected void forceEndValues() {
        if (this.target != null) {
            this.setValues(this.targetValues);
        }
    }

    @Override
    public boolean containsTarget(@NonNull Object target) {
        return this.target == target;
    }

    private void setValues(@NonNull float[] values) {
        this.tweenType.setValues(this.target, values);
        if (this.tweenAction != null) {
            this.tweenAction.apply(this.target);
        }
    }
}

