/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed;

import android.support.annotation.NonNull;
import io.noties.tumbleweed.BaseTween;
import io.noties.tumbleweed.BaseTweenDef;
import io.noties.tumbleweed.BaseTweenDefImpl;
import io.noties.tumbleweed.Timeline;
import io.noties.tumbleweed.TimelineDef;
import io.noties.tumbleweed.Tween;
import io.noties.tumbleweed.TweenCallback;
import io.noties.tumbleweed.TweenDef;
import io.noties.tumbleweed.TweenManager;
import java.util.ArrayList;
import java.util.List;

class TimelineDefImpl
extends TimelineDef {
    private final List<BaseTweenDef> children = new ArrayList<BaseTweenDef>(4);
    private final Mode mode;
    private final BaseTweenDefImpl impl = new BaseTweenDefImpl();

    TimelineDefImpl(@NonNull Mode mode) {
        this.mode = mode;
        this.current = this;
    }

    @Override
    @NonNull
    public TimelineDef push(@NonNull TweenDef<?> tween) {
        this.current.add(tween);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef push(@NonNull TimelineDef timeline) {
        if (timeline.current != timeline) {
            throw new RuntimeException("You forgot to call a few 'end()' statements in your pushed timeline");
        }
        timeline.parent = this.current;
        this.current.add(timeline);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef push(@NonNull BaseTweenDef baseTweenDef) {
        if (baseTweenDef instanceof TimelineDef) {
            this.push((TimelineDef)baseTweenDef);
        } else {
            this.current.add(baseTweenDef);
        }
        return this;
    }

    @Override
    @NonNull
    public TimelineDef pushPause(float duration) {
        this.current.add(Tween.mark().delay(duration));
        return this;
    }

    @Override
    @NonNull
    public TimelineDef beginSequence() {
        TimelineDefImpl timelineDef = new TimelineDefImpl(Mode.SEQUENCE);
        timelineDef.parent = this.current;
        this.current.add(timelineDef);
        this.current = timelineDef;
        return this;
    }

    @Override
    @NonNull
    public TimelineDef beginParallel() {
        TimelineDefImpl timelineDef = new TimelineDefImpl(Mode.PARALLEL);
        timelineDef.parent = this.current;
        this.current.add(timelineDef);
        this.current = timelineDef;
        return this;
    }

    @Override
    @NonNull
    public TimelineDef end() {
        if (this.current == this) {
            throw new RuntimeException("Nothing to end...");
        }
        this.current = this.current.parent;
        return this;
    }

    @Override
    @NonNull
    public Timeline build() {
        boolean isSequence = Mode.SEQUENCE == this.mode;
        float duration = 0.0f;
        int size = this.children.size();
        ArrayList<BaseTween> tweens = new ArrayList<BaseTween>(size);
        for (int i = 0; i < size; ++i) {
            BaseTweenDef baseTweenDef = this.children.get(i);
            if (baseTweenDef.repeatCount() < 0) {
                throw new RuntimeException("You can't push an object with infinite repetitions in a timeline");
            }
            if (isSequence) {
                float delay = duration;
                duration += baseTweenDef.fullDuration();
                baseTweenDef.delay(baseTweenDef.delay() + delay);
            } else {
                duration = Math.max(duration, baseTweenDef.fullDuration());
            }
            tweens.add(baseTweenDef.build());
        }
        this.impl.duration = duration;
        return new Timeline(this.impl, duration, tweens);
    }

    @Override
    @NonNull
    public Timeline start() {
        Timeline timeline = this.build();
        timeline.start();
        return timeline;
    }

    @Override
    @NonNull
    public Timeline start(@NonNull TweenManager tweenManager) {
        Timeline timeline = this.build();
        timeline.start(tweenManager);
        return timeline;
    }

    @Override
    @NonNull
    public TimelineDef delay(float duration) {
        this.impl.delay(duration);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef repeat(int count, float delay) {
        this.impl.repeat(count, delay);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef repeatYoyo(int count, float delay) {
        this.impl.repeatYoyo(count, delay);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef addCallback(@NonNull TweenCallback callback) {
        this.impl.addCallback(callback);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef addCallback(@TweenCallback.Event int callbackEvents, @NonNull TweenCallback callback) {
        this.impl.addCallback(callbackEvents, callback);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef userData(Object userData) {
        this.impl.userData(userData);
        return this;
    }

    @Override
    @NonNull
    public TimelineDef removeWhenFinished(boolean removeWhenFinished) {
        this.impl.removeWhenFinished(removeWhenFinished);
        return this;
    }

    @Override
    public int repeatCount() {
        return this.impl.repeatCount();
    }

    @Override
    public float delay() {
        return this.impl.delay();
    }

    @Override
    public float fullDuration() {
        boolean isSequence = Mode.SEQUENCE == this.mode;
        float duration = 0.0f;
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            BaseTweenDef baseTweenDef = this.children.get(i);
            if (baseTweenDef.repeatCount() < 0) {
                throw new RuntimeException("You can't push an object with infinite repetitions in a timeline");
            }
            if (isSequence) {
                duration += baseTweenDef.fullDuration();
                continue;
            }
            duration = Math.max(duration, baseTweenDef.fullDuration());
        }
        return duration;
    }

    @Override
    protected void add(@NonNull BaseTweenDef tweenDef) {
        this.children.add(tweenDef);
    }

    static enum Mode {
        SEQUENCE,
        PARALLEL;

    }
}

