/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed;

import android.support.annotation.NonNull;
import io.noties.tumbleweed.BaseTween;
import io.noties.tumbleweed.BaseTweenDefImpl;
import io.noties.tumbleweed.TimelineDef;
import io.noties.tumbleweed.TimelineDefImpl;
import io.noties.tumbleweed.TweenManager;
import java.util.List;

public final class Timeline
extends BaseTween {
    private final float duration;
    private final List<BaseTween> children;

    @NonNull
    public static TimelineDef createSequence() {
        return new TimelineDefImpl(TimelineDefImpl.Mode.SEQUENCE);
    }

    @NonNull
    public static TimelineDef createParallel() {
        return new TimelineDefImpl(TimelineDefImpl.Mode.PARALLEL);
    }

    Timeline(@NonNull BaseTweenDefImpl impl, float duration, @NonNull List<BaseTween> children) {
        super(impl);
        this.duration = duration;
        this.children = children;
    }

    @Override
    @NonNull
    public Timeline start(@NonNull TweenManager manager) {
        super.start(manager);
        return this;
    }

    @Override
    @NonNull
    public Timeline start() {
        super.start();
        for (int i = 0; i < this.children.size(); ++i) {
            BaseTween obj = this.children.get(i);
            obj.start();
        }
        return this;
    }

    @Override
    protected void updateOverride(int step, int lastStep, boolean isIterationStep, float delta) {
        if (!isIterationStep && step > lastStep) {
            if (!(delta >= 0.0f)) {
                throw new IllegalStateException("Assertion failed, delta >= 0");
            }
            float dt = this.isReverse(lastStep) ? -delta - 1.0f : delta + 1.0f;
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                this.children.get(i).update(dt);
            }
            return;
        }
        if (!isIterationStep && step < lastStep) {
            if (!(delta <= 0.0f)) {
                throw new IllegalStateException("Assertion failed, delta <= 0");
            }
            float dt = this.isReverse(lastStep) ? delta + 1.0f : -delta - 1.0f;
            for (int i = this.children.size() - 1; i >= 0; --i) {
                this.children.get(i).update(dt);
            }
            return;
        }
        if (!isIterationStep) {
            throw new IllegalStateException("Assertion failed, isIterationStep");
        }
        if (step > lastStep) {
            if (this.isReverse(step)) {
                this.forceEndValues();
                int n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    this.children.get(i).update(delta);
                }
            } else {
                this.forceStartValues();
                int n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    this.children.get(i).update(delta);
                }
            }
        } else if (step < lastStep) {
            if (this.isReverse(step)) {
                this.forceStartValues();
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    this.children.get(i).update(delta);
                }
            } else {
                this.forceEndValues();
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    this.children.get(i).update(delta);
                }
            }
        } else {
            float dt;
            float f = dt = this.isReverse(step) ? -delta : delta;
            if (delta >= 0.0f) {
                int n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    this.children.get(i).update(dt);
                }
            } else {
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    this.children.get(i).update(dt);
                }
            }
        }
    }

    @Override
    protected void forceStartValues() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.children.get(i).forceToStart();
        }
    }

    @Override
    protected void forceEndValues() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            this.children.get(i).forceToEnd(this.duration);
        }
    }

    @Override
    public boolean containsTarget(@NonNull Object target) {
        boolean result = false;
        for (BaseTween tween : this.children) {
            if (!tween.containsTarget(target)) continue;
            result = true;
            break;
        }
        return result;
    }
}

