/*
 * Decompiled with CFR 0.152.
 */
package io.noties.tumbleweed;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.noties.tumbleweed.BaseTweenDefImpl;
import io.noties.tumbleweed.TweenCallbacks;
import io.noties.tumbleweed.TweenManager;

public abstract class BaseTween {
    private final int repeatCount;
    private final float repeatDelay;
    private final float delay;
    private final boolean isYoyo;
    protected final float duration;
    private final float fullDuration;
    private int step;
    private boolean isIterationStep;
    private float currentTime;
    private float deltaTime;
    private boolean isStarted;
    private boolean isInitialized;
    private boolean isFinished;
    private boolean isKilled;
    private boolean isPaused;
    private final TweenCallbacks callbacks;
    private Object userData;
    private boolean isAutoRemoveEnabled;
    private boolean isAutoStartEnabled;

    BaseTween(@NonNull BaseTweenDefImpl def) {
        this.delay = def.delay;
        this.duration = def.duration;
        this.fullDuration = def.fullDuration();
        this.repeatCount = def.repeatCount;
        this.repeatDelay = def.repeatDelay;
        this.isYoyo = def.isYoyo;
        this.callbacks = def.callbacksBuilder.build();
        this.userData = def.userData;
        this.isAutoRemoveEnabled = def.removeWhenFinished;
    }

    @NonNull
    public BaseTween start() {
        this.isAutoStartEnabled = true;
        this.currentTime = 0.0f;
        this.isStarted = true;
        return this;
    }

    @NonNull
    public BaseTween start(@NonNull TweenManager manager) {
        this.isAutoStartEnabled = true;
        manager.add(this);
        return this;
    }

    public void kill() {
        this.isKilled = true;
    }

    public void pause() {
        this.isPaused = true;
    }

    public void resume() {
        this.isPaused = false;
    }

    public float getDelay() {
        return this.delay;
    }

    public float getDuration() {
        return this.duration;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public float getRepeatDelay() {
        return this.repeatDelay;
    }

    public float getFullDuration() {
        return this.fullDuration;
    }

    @Nullable
    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(@Nullable Object userData) {
        this.userData = userData;
    }

    public boolean autoRemoveEnabled() {
        return this.isAutoRemoveEnabled;
    }

    public boolean autoStartEnabled() {
        return this.isAutoStartEnabled;
    }

    public float getCurrentTime() {
        return this.currentTime;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isFinished() {
        return this.isFinished || this.isKilled;
    }

    public boolean isYoyo() {
        return this.isYoyo;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    protected abstract void forceStartValues();

    protected abstract void forceEndValues();

    public abstract boolean containsTarget(@NonNull Object var1);

    protected void initializeOverride() {
    }

    protected void updateOverride(int step, int lastStep, boolean isIterationStep, float delta) {
    }

    protected void forceToStart() {
        this.currentTime = -this.delay;
        this.step = -1;
        this.isIterationStep = false;
        if (this.isReverse(0)) {
            this.forceEndValues();
        } else {
            this.forceStartValues();
        }
    }

    protected void forceToEnd(float time) {
        this.currentTime = time - this.getFullDuration();
        this.step = this.repeatCount * 2 + 1;
        this.isIterationStep = false;
        if (this.isReverse(this.repeatCount * 2)) {
            this.forceStartValues();
        } else {
            this.forceEndValues();
        }
    }

    protected void callCallback(int type) {
        this.callbacks.call(type, this);
    }

    protected boolean isReverse(int step) {
        return this.isYoyo && Math.abs(step % 4) == 2;
    }

    protected boolean isValid(int step) {
        return step >= 0 && step <= this.repeatCount * 2 || this.repeatCount < 0;
    }

    public void killTarget(@NonNull Object target) {
        if (this.containsTarget(target)) {
            this.kill();
        }
    }

    public void update(float delta) {
        if (!this.isStarted || this.isPaused || this.isKilled) {
            return;
        }
        this.deltaTime = delta;
        if (!this.isInitialized) {
            this.initialize();
        }
        if (this.isInitialized) {
            this.testRelaunch();
            this.updateStep();
            this.testCompletion();
        }
        this.currentTime += this.deltaTime;
        this.deltaTime = 0.0f;
    }

    private void initialize() {
        if (Float.compare(this.currentTime + this.deltaTime, this.delay) > -1) {
            this.initializeOverride();
            this.isInitialized = true;
            this.isIterationStep = true;
            this.step = 0;
            this.deltaTime -= this.delay - this.currentTime;
            if (Float.compare(this.deltaTime, 0.0f) < 0) {
                this.deltaTime = 0.0f;
            }
            this.currentTime = 0.0f;
            this.callCallback(1);
            this.callCallback(2);
        }
    }

    private void testRelaunch() {
        if (!this.isIterationStep && this.repeatCount >= 0 && this.step < 0 && this.currentTime + this.deltaTime >= 0.0f) {
            if (this.step != -1) {
                throw new IllegalStateException("Assertion failed, step == -1");
            }
            this.isIterationStep = true;
            this.step = 0;
            float delta = 0.0f - this.currentTime;
            this.deltaTime -= delta;
            this.currentTime = 0.0f;
            this.callCallback(1);
            this.callCallback(2);
            this.updateOverride(this.step, this.step - 1, this.isIterationStep, delta);
        } else if (!this.isIterationStep && this.repeatCount >= 0 && this.step > this.repeatCount * 2 && this.currentTime + this.deltaTime < 0.0f) {
            if (this.step != this.repeatCount * 2 + 1) {
                throw new IllegalStateException("Assertion failed, step == repeatCount * 2 + 1");
            }
            this.isIterationStep = true;
            this.step = this.repeatCount * 2;
            float delta = 0.0f - this.currentTime;
            this.deltaTime -= delta;
            this.currentTime = this.duration;
            this.callCallback(16);
            this.callCallback(32);
            this.updateOverride(this.step, this.step + 1, this.isIterationStep, delta);
        }
    }

    private void updateStep() {
        while (this.isValid(this.step)) {
            float delta;
            if (!this.isIterationStep && this.currentTime + this.deltaTime <= 0.0f) {
                this.isIterationStep = true;
                --this.step;
                delta = 0.0f - this.currentTime;
                this.deltaTime -= delta;
                this.currentTime = this.duration;
                if (this.isReverse(this.step)) {
                    this.forceStartValues();
                } else {
                    this.forceEndValues();
                }
                this.callCallback(32);
                this.updateOverride(this.step, this.step + 1, this.isIterationStep, delta);
                continue;
            }
            if (!this.isIterationStep && this.currentTime + this.deltaTime >= this.repeatDelay) {
                this.isIterationStep = true;
                ++this.step;
                delta = this.repeatDelay - this.currentTime;
                this.deltaTime -= delta;
                this.currentTime = 0.0f;
                if (this.isReverse(this.step)) {
                    this.forceEndValues();
                } else {
                    this.forceStartValues();
                }
                this.callCallback(2);
                this.updateOverride(this.step, this.step - 1, this.isIterationStep, delta);
                continue;
            }
            if (this.isIterationStep && this.currentTime + this.deltaTime < 0.0f) {
                this.isIterationStep = false;
                --this.step;
                delta = 0.0f - this.currentTime;
                this.deltaTime -= delta;
                this.currentTime = 0.0f;
                this.updateOverride(this.step, this.step + 1, this.isIterationStep, delta);
                this.callCallback(64);
                if (this.step < 0 && this.repeatCount >= 0) {
                    this.callCallback(128);
                    continue;
                }
                this.currentTime = this.repeatDelay;
                continue;
            }
            if (this.isIterationStep && this.currentTime + this.deltaTime > this.duration) {
                this.isIterationStep = false;
                ++this.step;
                delta = this.duration - this.currentTime;
                this.deltaTime -= delta;
                this.currentTime = this.duration;
                this.updateOverride(this.step, this.step - 1, this.isIterationStep, delta);
                this.callCallback(4);
                if (this.step > this.repeatCount * 2 && this.repeatCount >= 0) {
                    this.callCallback(8);
                }
                this.currentTime = 0.0f;
                continue;
            }
            if (this.isIterationStep) {
                delta = this.deltaTime;
                this.deltaTime -= delta;
                this.currentTime += delta;
                this.updateOverride(this.step, this.step, this.isIterationStep, delta);
                break;
            }
            delta = this.deltaTime;
            this.deltaTime -= delta;
            this.currentTime += delta;
            break;
        }
    }

    private void testCompletion() {
        this.isFinished = this.repeatCount >= 0 && (this.step > this.repeatCount * 2 || this.step < 0);
    }
}

