/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.client.channel.factory;

import io.grpc.netty.NettyChannelBuilder;
import io.nity.grpc.client.channel.configurer.GrpcChannelBuilderConfigurer;
import io.nity.grpc.client.channel.configurer.GrpcChannelConfigurer;
import io.nity.grpc.client.channel.factory.AbstractChannelFactory;
import io.nity.grpc.client.config.GrpcClientProperties;
import io.nity.grpc.client.config.GrpcClientPropertiesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SimpleChannelFactory
extends AbstractChannelFactory<NettyChannelBuilder> {
    private static final Logger log = LoggerFactory.getLogger(SimpleChannelFactory.class);

    public SimpleChannelFactory(GrpcClientPropertiesMap clientPropertiesMap, GrpcChannelBuilderConfigurer channelBuilderConfigurer, GrpcChannelConfigurer channelConfigurer) {
        super(clientPropertiesMap, channelBuilderConfigurer, channelConfigurer);
    }

    @Override
    protected NettyChannelBuilder newChannelBuilder(String name, GrpcClientProperties clientProperties) {
        String host = clientProperties.getHost();
        int port = clientProperties.getPort();
        if (!StringUtils.hasText((String)host)) {
            log.error("please config required property [host] for simple model");
            throw new RuntimeException("Failed to create channel without tls");
        }
        log.info("will create channel without tls. recommend only use in internal service");
        log.info("creating channel on {}:{}", (Object)host, (Object)port);
        NettyChannelBuilder nettyChannelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).usePlaintext();
        return nettyChannelBuilder;
    }
}

