/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.client.channel;

import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DisposableManagedChannel
extends ManagedChannel
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DisposableManagedChannel.class);
    private ManagedChannel channel;

    public DisposableManagedChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.channel.newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.channel.authority();
    }

    public void destroy() throws Exception {
        log.info("Shutting down gRPC channel ...");
        log.info("awaitTermination 5 sec.");
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public ManagedChannel shutdown() {
        return this.channel.shutdown();
    }

    public boolean isShutdown() {
        return this.channel.isShutdown();
    }

    public boolean isTerminated() {
        return this.channel.isTerminated();
    }

    public ManagedChannel shutdownNow() {
        return this.channel.shutdownNow();
    }

    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.channel.awaitTermination(l, timeUnit);
    }
}

