/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.client.autoconfigure;

import io.grpc.ManagedChannelBuilder;
import io.nity.grpc.client.channel.configurer.GrpcChannelBuilderConfigurer;
import io.nity.grpc.client.channel.configurer.GrpcChannelConfigurer;
import io.nity.grpc.client.channel.factory.CustomChannelFactory;
import io.nity.grpc.client.channel.factory.GrpcChannelFactoryFacede;
import io.nity.grpc.client.config.GrpcClientProperties;
import io.nity.grpc.client.config.GrpcClientPropertiesMap;
import io.nity.grpc.client.inject.GrpcClientBeanPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder
public class GrpcClientAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientAutoConfiguration.class);

    @Bean
    public GrpcClientBeanPostProcessor grpcClientBeanPostProcessor(ApplicationContext applicationContext) {
        return new GrpcClientBeanPostProcessor(applicationContext);
    }

    @ConditionalOnMissingBean
    @Bean
    public GrpcClientPropertiesMap clientPropertiesMap() {
        return new GrpcClientPropertiesMap();
    }

    @ConditionalOnMissingBean(value={GrpcChannelBuilderConfigurer.class})
    @Bean
    public GrpcChannelBuilderConfigurer defaultChannelBuilderConfigure() {
        return (channelBuilder, name) -> log.info("configure in defaultChannelBuilderConfigure, no op...");
    }

    @ConditionalOnMissingBean(value={GrpcChannelConfigurer.class})
    @Bean
    public GrpcChannelConfigurer defaultChannelConfigurer() {
        return (channel, name) -> log.info("configure in defaultChannelConfigurer, no op...");
    }

    @Bean
    public GrpcChannelFactoryFacede grpcChannelFactoryFacede(ApplicationContext applicationContext, GrpcClientPropertiesMap clientPropertiesMap, GrpcChannelBuilderConfigurer channelBuilderConfigurer, GrpcChannelConfigurer channelConfigurer) {
        return new GrpcChannelFactoryFacede(applicationContext, clientPropertiesMap, channelBuilderConfigurer, channelConfigurer);
    }

    @ConditionalOnMissingBean(value={CustomChannelFactory.class})
    @Bean
    public CustomChannelFactory customChannelFactory(GrpcClientPropertiesMap clientPropertiesMap, GrpcChannelBuilderConfigurer channelBuilderConfigurer, GrpcChannelConfigurer channelConfigurer) {
        return new CustomChannelFactory(clientPropertiesMap, channelBuilderConfigurer, channelConfigurer){

            protected ManagedChannelBuilder newChannelBuilder(String name, GrpcClientProperties clientProperties) {
                throw new RuntimeException("must create CustomChannelFactory instance for custom model!");
            }
        };
    }
}

