/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.autoconfigure;

import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.nity.grpc.DisposableManagedChannel;
import io.nity.grpc.autoconfigure.GrpcClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfigureOrder
public class GrpcClientInProcessAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientInProcessAutoConfiguration.class);
    @Autowired
    private GrpcClientProperties clientProperties;

    @Bean
    @ConditionalOnProperty(value={"grpc.client.model"}, havingValue="inProcess")
    public DisposableManagedChannel getChannel() {
        String inProcessServerName = this.clientProperties.getInProcessServerName();
        if (!StringUtils.hasText((String)inProcessServerName)) {
            log.error("please config required property [inProcessServerName] for InProcess model");
            throw new RuntimeException("Failed to create inProcessChannel");
        }
        log.warn("will create InProcessChannel. Please only use in testing");
        ManagedChannel channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)inProcessServerName).directExecutor()).build();
        DisposableManagedChannel disposableManagedChannel = new DisposableManagedChannel(channel);
        return disposableManagedChannel;
    }
}

