/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DisposableManagedChannel
extends Channel
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DisposableManagedChannel.class);
    private ManagedChannel channel;

    public DisposableManagedChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.channel.newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.channel.authority();
    }

    public void destroy() throws Exception {
        log.info("Shutting down gRPC channel ...");
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }
}

