/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.autoconfigure;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.nity.grpc.DisposableManagedChannel;
import io.nity.grpc.autoconfigure.GrpcClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfigureOrder
public class GrpcClientSimpleAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientSimpleAutoConfiguration.class);
    @Autowired
    private GrpcClientProperties clientProperties;

    @Bean
    @ConditionalOnProperty(value={"grpc.client.model"}, havingValue="simple")
    public DisposableManagedChannel getChannel() {
        int port = this.clientProperties.getPort();
        String host = this.clientProperties.getHost();
        if (!StringUtils.hasText((String)host)) {
            log.error("please config required property [host] for simple model");
            throw new RuntimeException("Failed to create channel without tls");
        }
        log.info("will create channel without tls. recommend only use in internal service");
        log.info("creating channel on {}:{}", (Object)host, (Object)port);
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        DisposableManagedChannel disposableManagedChannel = new DisposableManagedChannel(channel);
        return disposableManagedChannel;
    }
}

