/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

final class Half {
    public static final int MAX_EXPONENT = 15;
    public static final int MIN_EXPONENT = -14;
    public static final float MAX_VALUE = 65504.0f;
    public static final float MIN_VALUE = 6.1035156E-5f;
    public static final float MIN_NORMAL = 5.9604645E-8f;
    public static final float EPSILON = 9.765625E-4f;
    public static int MAX_EXACT_INT_RANGE_VALUE = 2048;
    public static int MIN_EXACT_INT_RANGE_VALUE = -2048;
    public static float SIZE = 16.0f;
    public static final float NaN = Float.NaN;
    public static final float POSITIVE_INFINITY = Float.POSITIVE_INFINITY;
    public static final float NEGATIVE_INFINITY = Float.NEGATIVE_INFINITY;
    private static final int FP16_SIGN_SHIFT = 15;
    private static final int FP16_SIGN_MASK = 32768;
    private static final int FP16_EXPONENT_SHIFT = 10;
    private static final int FP16_EXPONENT_MASK = 31;
    private static final int FP16_SIGNIFICAND_MASK = 1023;
    private static final int FP16_EXPONENT_BIAS = 15;
    private static final int FP32_SIGN_SHIFT = 31;
    private static final int FP32_EXPONENT_SHIFT = 23;
    private static final int FP32_EXPONENT_MASK = 255;
    private static final int FP32_SIGNIFICAND_MASK = 0x7FFFFF;
    private static final int FP32_EXPONENT_BIAS = 127;
    private static final int FP32_DENORMAL_MAGIC = 0x3F000000;
    private static final float FP32_DENORMAL_FLOAT = Float.intBitsToFloat(0x3F000000);

    private Half() {
    }

    public static float shortBitsToFloat(short h) {
        int bits = h & 0xFFFF;
        int s = bits & 0x8000;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        int outE = 0;
        int outM = 0;
        if (e == 0) {
            if (m != 0) {
                float o = Float.intBitsToFloat(0x3F000000 + m);
                return s == 0 ? o : -(o -= FP32_DENORMAL_FLOAT);
            }
        } else {
            outM = m << 13;
            outE = e == 31 ? 255 : e - 15 + 127;
        }
        int out = s << 16 | outE << 23 | outM;
        return Float.intBitsToFloat(out);
    }

    public static short floatToRawShortBits(float f) {
        int bits = Float.floatToRawIntBits(f);
        int s = bits >>> 31;
        int e = bits >>> 23 & 0xFF;
        int m = bits & 0x7FFFFF;
        int outE = 0;
        int outM = 0;
        if (e == 255) {
            outE = 31;
            outM = m != 0 ? 512 : 0;
        } else if ((e = e - 127 + 15) >= 31) {
            outE = 49;
        } else if (e <= 0) {
            if (e >= -10) {
                if (((m = (m | 0x800000) >> 1 - e) & 0x1000) != 0) {
                    m += 8192;
                }
                outM = m >> 13;
            }
        } else {
            outE = e;
            outM = m >> 13;
            if ((m & 0x1000) != 0) {
                int out = outE << 10 | outM;
                return (short)(++out | s << 15);
            }
        }
        return (short)(s << 15 | outE << 10 | outM);
    }
}

