/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.EncoderStream;
import java.io.IOException;
import java.io.OutputStream;

class EncoderStream_OutputStream
implements EncoderStream {
    private final OutputStream mOutputStream;
    private int mLength = 0;

    EncoderStream_OutputStream(OutputStream outputStream) {
        this.mOutputStream = outputStream;
    }

    @Override
    public int length() {
        return this.mLength;
    }

    @Override
    public EncoderStream put(byte x) throws IOException {
        this.mOutputStream.write(x & 0xFF);
        ++this.mLength;
        return this;
    }

    @Override
    public EncoderStream putShort(short x) throws IOException {
        this.mOutputStream.write(x >> 8 & 0xFF);
        this.mOutputStream.write(x & 0xFF);
        this.mLength += 2;
        return this;
    }

    @Override
    public EncoderStream putInt(int x) throws IOException {
        this.mOutputStream.write(x >> 24 & 0xFF);
        this.mOutputStream.write(x >> 16 & 0xFF);
        this.mOutputStream.write(x >> 8 & 0xFF);
        this.mOutputStream.write(x & 0xFF);
        this.mLength += 4;
        return this;
    }

    @Override
    public EncoderStream putLong(long x) throws IOException {
        this.mOutputStream.write((int)(x >> 56) & 0xFF);
        this.mOutputStream.write((int)(x >> 48) & 0xFF);
        this.mOutputStream.write((int)(x >> 40) & 0xFF);
        this.mOutputStream.write((int)(x >> 32) & 0xFF);
        this.mOutputStream.write((int)(x >> 24) & 0xFF);
        this.mOutputStream.write((int)(x >> 16) & 0xFF);
        this.mOutputStream.write((int)(x >> 8) & 0xFF);
        this.mOutputStream.write((int)x & 0xFF);
        this.mLength += 8;
        return this;
    }
}

