/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborArray;
import com.google.iot.cbor.CborByteString;
import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborFloat;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborMap;
import com.google.iot.cbor.CborParseException;
import com.google.iot.cbor.CborReader;
import com.google.iot.cbor.CborRuntimeException;
import com.google.iot.cbor.CborSimple;
import com.google.iot.cbor.CborTextString;
import com.google.iot.cbor.CborWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CborObject {
    static final int ADDITIONAL_INFO_EXTRA_1B = 24;
    static final int ADDITIONAL_INFO_EXTRA_2B = 25;
    static final int ADDITIONAL_INFO_EXTRA_4B = 26;
    static final int ADDITIONAL_INFO_EXTRA_8B = 27;
    static final int ADDITIONAL_INFO_EXTRA_INDEF = 31;

    CborObject() {
    }

    public static CborObject createFromCborByteArray(byte[] input, int offset, int length) throws CborParseException {
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (length < 1) {
            throw new IllegalArgumentException("length must be greater than 1");
        }
        if (input.length < offset) {
            throw new IndexOutOfBoundsException("offset is larger than byte array");
        }
        if (input.length < offset + length) {
            throw new IndexOutOfBoundsException("offset+length is larger than byte array");
        }
        try {
            CborReader reader = CborReader.createFromByteArray(input, offset, 1);
            CborObject ret = reader.readDataItem();
            if (reader.bytesParsed() > (long)length) {
                throw new CborParseException("data item is truncated");
            }
            if (reader.bytesParsed() < (long)length) {
                throw new CborParseException("extra data at end of data item (parsed only " + reader.bytesParsed() + " of " + length + " bytes)");
            }
            return ret;
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    public static CborObject createFromCborByteArray(byte[] input) throws CborParseException {
        return CborObject.createFromCborByteArray(input, 0, input.length);
    }

    public static CborObject createFromJavaObject(@Nullable Object obj) throws CborConversionException {
        if (obj == null) {
            return CborSimple.NULL;
        }
        if (obj instanceof CborObject) {
            byte[] cborBytes = ((CborObject)obj).toCborByteArray();
            return CborByteString.create(cborBytes, 0, cborBytes.length, 24);
        }
        if (obj instanceof Float) {
            return CborFloat.create(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return CborFloat.create((Double)obj);
        }
        if (obj instanceof BigDecimal) {
            return CborFloat.create(((BigDecimal)obj).doubleValue());
        }
        if (obj instanceof BigInteger && ((BigInteger)obj).compareTo(CborInteger.BI_MAX_8B) <= 0 && ((BigInteger)obj).compareTo(CborInteger.BI_MIN_8B) >= 0) {
            return CborInteger.create((BigInteger)obj);
        }
        if (obj instanceof Integer) {
            return CborInteger.create(BigInteger.valueOf(((Integer)obj).intValue()));
        }
        if (obj instanceof Long) {
            return CborInteger.create(BigInteger.valueOf((Long)obj));
        }
        if (obj instanceof Short) {
            return CborInteger.create(BigInteger.valueOf(((Short)obj).shortValue()));
        }
        if (obj instanceof String) {
            return CborTextString.create((String)obj);
        }
        if (obj instanceof byte[]) {
            return CborByteString.create((byte[])obj);
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                return CborSimple.TRUE;
            }
            return CborSimple.FALSE;
        }
        if (obj instanceof Map) {
            return CborMap.createFromJavaObject((Map)obj);
        }
        if (obj instanceof Iterable) {
            return CborArray.createFromJavaObject((Iterable)obj);
        }
        if (obj instanceof URI) {
            URI uri = (URI)obj;
            return CborTextString.create(uri.toASCIIString(), 32);
        }
        if (obj instanceof BigInteger) {
            int tag;
            BigInteger bint = (BigInteger)obj;
            if (bint.signum() < 0) {
                tag = 3;
                bint = bint.negate();
            } else {
                tag = 2;
            }
            byte[] byteArray = bint.toByteArray();
            if (byteArray.length > 0 && byteArray[0] == 0) {
                return CborByteString.create(byteArray, 1, byteArray.length - 1, tag);
            }
            return CborByteString.create(byteArray, 0, byteArray.length, tag);
        }
        if (obj instanceof int[]) {
            return CborArray.createFromJavaObject((int[])obj);
        }
        if (obj instanceof short[]) {
            return CborArray.createFromJavaObject((short[])obj);
        }
        if (obj instanceof long[]) {
            return CborArray.createFromJavaObject((long[])obj);
        }
        if (obj instanceof boolean[]) {
            return CborArray.createFromJavaObject((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return CborArray.createFromJavaObject((float[])obj);
        }
        if (obj instanceof double[]) {
            return CborArray.createFromJavaObject((double[])obj);
        }
        if (obj instanceof Object[]) {
            return CborArray.createFromJavaObject((Object[])obj);
        }
        throw new CborConversionException("Unable to convert java type \"" + obj.getClass().getCanonicalName() + "\" to CborObject");
    }

    public int getTag() {
        return -1;
    }

    public abstract int getMajorType();

    public abstract int getAdditionalInformation();

    public abstract boolean isValidJson();

    public abstract String toJsonString();

    public abstract @Nullable Object toJavaObject();

    public abstract <T> T toJavaObject(Class<T> var1) throws CborConversionException;

    public abstract CborObject copy();

    public final byte[] toCborByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(CborWriter.length(this));
        try {
            CborWriter.createFromByteBuffer(byteBuffer).writeDataItem(this);
        }
        catch (IOException x) {
            throw new CborRuntimeException(x);
        }
        return byteBuffer.array();
    }

    public String toString() {
        return this.toString(-1);
    }

    public abstract String toString(int var1);
}

