/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborIntegerImpl;
import com.google.iot.cbor.CborNumber;
import com.google.iot.cbor.CborObject;
import java.math.BigInteger;
import javax.annotation.Nullable;

public abstract class CborInteger
extends CborObject
implements CborNumber {
    static final BigInteger BI_ADDITIONAL_INFO_EXTRA_1B = BigInteger.valueOf(24L);
    static final BigInteger BI_MAX_1B = BigInteger.valueOf(255L);
    static final BigInteger BI_MAX_2B = BigInteger.valueOf(65535L);
    static final BigInteger BI_MAX_4B = BigInteger.valueOf(0xFFFFFFFFL);
    static final BigInteger BI_MAX_8B = new BigInteger("18446744073709551615");
    static final BigInteger BI_MIN_8B = new BigInteger("-18446744073709551616");

    CborInteger() {
    }

    public static CborInteger create(Number value) {
        return CborInteger.create(value, -1);
    }

    public static CborInteger create(Number value, int tag) {
        return CborInteger.create(value, tag, null, null);
    }

    public static CborInteger create(Number value, int tag, @Nullable Integer majorType, @Nullable Byte additionalInfo) {
        if (value.getClass().isAssignableFrom(BigInteger.class)) {
            return new CborIntegerImpl((BigInteger)value, tag, majorType, additionalInfo);
        }
        return new CborIntegerImpl(BigInteger.valueOf(value.longValue()), tag, majorType, additionalInfo);
    }

    static int calcAdditionalInformation(BigInteger val) {
        if (val.compareTo(BigInteger.ZERO) < 0) {
            val = val.negate().subtract(BigInteger.ONE);
        }
        if (val.compareTo(BI_ADDITIONAL_INFO_EXTRA_1B) < 0) {
            return val.byteValue();
        }
        if (val.compareTo(BI_MAX_1B) <= 0) {
            return 24;
        }
        if (val.compareTo(BI_MAX_2B) <= 0) {
            return 25;
        }
        if (val.compareTo(BI_MAX_4B) <= 0) {
            return 26;
        }
        return 27;
    }

    @Override
    public int getAdditionalInformation() {
        return CborInteger.calcAdditionalInformation(this.bigIntegerValue());
    }

    @Override
    public int getMajorType() {
        return this.bigIntegerValue().compareTo(BigInteger.ZERO) < 0 ? 1 : 0;
    }

    @Override
    public abstract long longValue();

    @Override
    public final float floatValue() {
        return this.longValue();
    }

    @Override
    public final double doubleValue() {
        return this.longValue();
    }

    @Override
    public final CborInteger copy() {
        return this;
    }

    @Override
    public final boolean isValidJson() {
        return true;
    }

    @Override
    public final String toJsonString() {
        return Long.toString(this.longValue());
    }

    @Override
    public Number toJavaObject() {
        BigInteger bigIntVal = this.bigIntegerValue();
        if (bigIntVal.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || bigIntVal.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            return bigIntVal;
        }
        long lval = this.longValue();
        if (lval > Integer.MAX_VALUE || lval < Integer.MIN_VALUE) {
            return lval;
        }
        return (int)lval;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        if (clazz.isAssignableFrom(Number.class) || Object.class.equals(clazz)) {
            return clazz.cast(this.toJavaObject());
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return clazz.cast(Float.valueOf(this.floatValue()));
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return clazz.cast(this.doubleValue());
        }
        if (clazz.isAssignableFrom(BigInteger.class)) {
            return clazz.cast(this.bigIntegerValue());
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return clazz.cast(this.longValue());
        }
        try {
            if (clazz.isAssignableFrom(Integer.class)) {
                return clazz.cast(this.intValueExact());
            }
            if (clazz.isAssignableFrom(Short.class)) {
                return clazz.cast(this.shortValueExact());
            }
        }
        catch (ArithmeticException x) {
            throw new CborConversionException(x);
        }
        throw new CborConversionException(String.format("%s is not assignable from %s", clazz, Long.class));
    }

    public final int hashCode() {
        return (this.getTag() - -1) * 1337 + Double.hashCode(this.doubleValue()) ^ Long.hashCode(this.longValue());
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CborObject)) {
            return false;
        }
        if (this.getTag() != ((CborObject)obj).getTag()) {
            return false;
        }
        if (obj instanceof CborInteger) {
            CborInteger rhs = (CborInteger)obj;
            return this.bigIntegerValue().compareTo(rhs.bigIntegerValue()) == 0;
        }
        if (!(obj instanceof CborNumber)) {
            return false;
        }
        CborNumber rhs = (CborNumber)obj;
        return this.longValue() == rhs.longValue() && Double.doubleToRawLongBits(this.doubleValue()) == Double.doubleToRawLongBits(rhs.doubleValue());
    }

    @Override
    public String toString(int ignore) {
        return this.toString();
    }

    @Override
    public String toString() {
        String ret = this.bigIntegerValue().toString();
        int tag = this.getTag();
        return tag == -1 ? ret : tag + "(" + ret + ")";
    }
}

