/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborFloat;
import com.google.iot.cbor.CborTag;

final class CborFloatImpl
extends CborFloat {
    private final double mValue;
    private final int mTag;
    private int mType;

    @Override
    public int getTag() {
        return this.mTag;
    }

    public static CborFloat createHalf(float value, int tag) {
        CborFloatImpl ret = new CborFloatImpl(value, tag);
        ret.mType = 25;
        return ret;
    }

    CborFloatImpl(float value, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mTag = tag;
        this.mValue = value;
        this.mType = 26;
    }

    CborFloatImpl(double value, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mTag = tag;
        this.mValue = value;
        this.mType = 27;
    }

    @Override
    public int getAdditionalInformation() {
        return this.mType;
    }

    @Override
    public float floatValue() {
        return (float)this.mValue;
    }

    @Override
    public double doubleValue() {
        return this.mValue;
    }
}

