/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborFloatImpl;
import com.google.iot.cbor.CborNumber;
import com.google.iot.cbor.CborObject;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class CborFloat
extends CborObject
implements CborNumber {
    public static final int TYPE_HALF = 25;
    public static final int TYPE_FLOAT = 26;
    public static final int TYPE_DOUBLE = 27;

    CborFloat() {
    }

    public static CborFloat createHalf(float value) {
        return CborFloat.createHalf(value, -1);
    }

    public static CborFloat createHalf(float value, int tag) {
        return CborFloatImpl.createHalf(value, tag);
    }

    public static CborFloat create(float value) {
        return CborFloat.create(value, -1);
    }

    public static CborFloat create(float value, int tag) {
        return new CborFloatImpl(value, tag);
    }

    public static CborFloat create(double value) {
        return CborFloat.create(value, -1);
    }

    public static CborFloat create(double value, int tag) {
        return new CborFloatImpl(value, tag);
    }

    @Override
    public abstract float floatValue();

    @Override
    public abstract double doubleValue();

    @Override
    public final long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public final BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public final int getMajorType() {
        return 7;
    }

    @Override
    public final String toJsonString() {
        double value = this.doubleValue();
        if (this.isValidJson()) {
            switch (this.getAdditionalInformation()) {
                default: {
                    return Double.toString(value);
                }
                case 25: 
                case 26: 
            }
            return Float.toString((float)value);
        }
        return "null";
    }

    @Override
    public final CborFloat copy() {
        return this;
    }

    @Override
    public final boolean isValidJson() {
        return Double.isFinite(this.doubleValue());
    }

    public final int hashCode() {
        return (this.getTag() - -1) * 1337 + Double.hashCode(this.doubleValue()) ^ Long.hashCode(this.longValue());
    }

    @Override
    public Number toJavaObject() {
        return BigDecimal.valueOf(this.doubleValue());
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        if (clazz.isAssignableFrom(Number.class) || Object.class.equals(clazz)) {
            return clazz.cast(this.toJavaObject());
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return clazz.cast(Float.valueOf(this.floatValue()));
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return clazz.cast(this.doubleValue());
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return clazz.cast(this.longValue());
        }
        try {
            if (clazz.isAssignableFrom(Integer.class)) {
                return clazz.cast(this.intValueExact());
            }
            if (clazz.isAssignableFrom(Short.class)) {
                return clazz.cast(this.shortValueExact());
            }
        }
        catch (ArithmeticException x) {
            throw new CborConversionException(x);
        }
        throw new CborConversionException(String.format("%s is not assignable from %s", clazz, Double.class));
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CborObject)) {
            return false;
        }
        if (this.getTag() != ((CborObject)obj).getTag()) {
            return false;
        }
        if (obj instanceof CborFloat) {
            CborFloat rhs = (CborFloat)obj;
            return Double.doubleToRawLongBits(this.doubleValue()) == Double.doubleToRawLongBits(rhs.doubleValue());
        }
        if (!(obj instanceof CborNumber)) {
            return false;
        }
        CborNumber rhs = (CborNumber)obj;
        return this.longValue() == rhs.longValue() && Double.doubleToRawLongBits(this.doubleValue()) == Double.doubleToRawLongBits(rhs.doubleValue());
    }

    @Override
    public String toString(int ignore) {
        return this.toString();
    }

    @Override
    public String toString() {
        int ai = this.getAdditionalInformation();
        Object ret = ai == 27 ? Double.toString(this.doubleValue()) : Float.toString(this.floatValue());
        ret = (String)ret + "_" + (ai - 24);
        int tag = this.getTag();
        return tag == -1 ? ret : tag + "(" + (String)ret + ")";
    }
}

