/*
 * Copyright (C) 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.iot.cbor;

/**
 * Checked datatype conversion exception. This exception is thrown when an attempt at converting an
 * arbitrary Java object to a {@link CborObject} (for example, via {@link
 * CborObject#createFromJavaObject(Object)}) fails. This is generally because the given Java object
 * class (or the class of one of it's contained objects) is not supported for conversion. This
 * exception can also be generated by {@link CborMap#toNormalMap()}.
 */
public class CborConversionException extends CborException {

    /**
     * Constructs a new {@link CborConversionException}.
     */
    public CborConversionException() {}

    /**
     * Constructs a new {@link CborConversionException} with the given explanation.
     * @param explain the explanation
     */
    public CborConversionException(String explain) {
        super(explain);
    }

    /**
     * Constructs a new {@link CborConversionException} with the given explanation and cause.
     * @param explain the explanation
     * @param t the cause
     */
    public CborConversionException(String explain, Throwable t) {
        super(explain, t);
    }

    /**
     * Constructs a new {@link CborConversionException} with the given cause.
     * @param t the cause
     */
    public CborConversionException(Throwable t) {
        super(t);
    }
}
