/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import java.math.BigInteger;

public interface CborNumber {
    public long longValue();

    public BigInteger bigIntegerValue();

    public float floatValue();

    public double doubleValue();

    default public byte byteValueExact() {
        long value = this.longValue();
        if (value > 127L || value < -128L) {
            throw new ArithmeticException("Value does not fit in a byte");
        }
        return (byte)value;
    }

    default public short shortValueExact() {
        long value = this.longValue();
        if (value > 32767L || value < -32768L) {
            throw new ArithmeticException("Value does not fit in a short");
        }
        return (short)value;
    }

    default public int intValueExact() {
        long value = this.longValue();
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new ArithmeticException("Value does not fit in a int");
        }
        return (int)value;
    }
}

