/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborTag;
import java.math.BigInteger;
import javax.annotation.Nullable;

final class CborIntegerImpl
extends CborInteger {
    private final BigInteger mValue;
    private final int mTag;
    private final Integer mMajorType;
    private final Byte mAdditionalInfo;

    @Override
    public int getTag() {
        return this.mTag;
    }

    CborIntegerImpl(BigInteger value, int tag, @Nullable Integer majorType, @Nullable Byte additionalInfo) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mTag = tag;
        this.mValue = value;
        this.mMajorType = majorType;
        this.mAdditionalInfo = additionalInfo;
    }

    @Override
    public int getMajorType() {
        if (this.mMajorType != null) {
            return this.mMajorType;
        }
        return super.getMajorType();
    }

    @Override
    public long longValue() {
        return this.mValue.longValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.mValue;
    }

    @Override
    public int getAdditionalInformation() {
        if (this.mAdditionalInfo != null) {
            return this.mAdditionalInfo.byteValue();
        }
        return super.getAdditionalInformation();
    }
}

