/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.CborArray;
import com.google.iot.cbor.CborByteString;
import com.google.iot.cbor.CborFloat;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborMap;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborRuntimeException;
import com.google.iot.cbor.CborSimple;
import com.google.iot.cbor.CborTextString;
import com.google.iot.cbor.CborWriter;
import com.google.iot.cbor.EncoderStream;
import it.unimi.dsi.fastutil.BigArrays;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Map;

class CborWriterImpl
implements CborWriter {
    private static final byte BREAK = -1;
    private final EncoderStream mEncoderStream;

    CborWriterImpl(OutputStream outputStream) {
        this.mEncoderStream = EncoderStream.create(outputStream);
    }

    CborWriterImpl(ByteBuffer byteBuffer) {
        this.mEncoderStream = EncoderStream.create(byteBuffer);
    }

    private CborWriterImpl() {
        this.mEncoderStream = EncoderStream.create();
    }

    static int length(CborObject obj) {
        int ret = 0;
        try {
            ret = new CborWriterImpl().writeDataItem((CborObject)obj).mEncoderStream.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    private void writeCborHeader(int majorType, int val) throws IOException {
        this.mEncoderStream.put((byte)((majorType << 5) + (val & 0x1F)));
    }

    private void writeCborFullInteger(int majorType, BigInteger val) throws IOException {
        if (val.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("val cannot be negative");
        }
        int ai = CborInteger.calcAdditionalInformation(val);
        this.writeCborHeader(majorType, ai);
        switch (ai) {
            case 24: {
                this.mEncoderStream.put(val.byteValue());
                break;
            }
            case 25: {
                this.mEncoderStream.putShort(val.shortValue());
                break;
            }
            case 26: {
                this.mEncoderStream.putInt(val.intValue());
                break;
            }
            case 27: {
                this.mEncoderStream.putLong(val.longValue());
            }
        }
    }

    @Override
    @CanIgnoreReturnValue
    public CborWriter writeTag(int tag) throws IOException {
        if (tag != -1) {
            this.writeCborFullInteger(6, BigInteger.valueOf(tag));
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public CborWriterImpl writeDataItem(CborObject obj) throws IOException {
        this.writeTag(obj.getTag());
        if (obj instanceof CborArray) {
            return this.writeDataItem((CborArray)obj);
        }
        if (obj instanceof CborFloat) {
            return this.writeDataItem((CborFloat)obj);
        }
        if (obj instanceof CborInteger) {
            return this.writeDataItem((CborInteger)obj);
        }
        if (obj instanceof CborMap) {
            return this.writeDataItem((CborMap)obj);
        }
        if (obj instanceof CborTextString) {
            return this.writeDataItem((CborTextString)obj);
        }
        if (obj instanceof CborByteString) {
            return this.writeDataItem((CborByteString)obj);
        }
        if (obj instanceof CborSimple) {
            return this.writeDataItem((CborSimple)obj);
        }
        throw new CborRuntimeException("Can't encode \"" + obj + "\" of type " + obj.getClass());
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborArray array) throws IOException {
        if (array.isIndefiniteLength()) {
            this.writeCborHeader(array.getMajorType(), 31);
        } else {
            this.writeCborFullInteger(array.getMajorType(), BigInteger.valueOf(array.size()));
        }
        for (CborObject obj : array) {
            this.writeDataItem(obj);
        }
        if (array.isIndefiniteLength()) {
            this.mEncoderStream.put((byte)-1);
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborFloat obj) throws IOException {
        this.writeCborHeader(obj.getMajorType(), obj.getAdditionalInformation());
        switch (obj.getAdditionalInformation()) {
            case 25: {
                this.mEncoderStream.putHalf(obj.floatValue());
                break;
            }
            case 26: {
                this.mEncoderStream.putFloat(obj.floatValue());
                break;
            }
            case 27: {
                this.mEncoderStream.putDouble(obj.floatValue());
            }
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborInteger obj) throws IOException {
        BigInteger val = obj.bigIntegerValue();
        if (val.compareTo(BigInteger.ZERO) < 0) {
            val = val.negate().subtract(BigInteger.ONE);
        }
        this.writeCborFullInteger(obj.getMajorType(), val);
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborMap map) throws IOException {
        if (map.isIndefiniteLength()) {
            this.writeCborHeader(map.getMajorType(), 31);
        } else {
            this.writeCborFullInteger(map.getMajorType(), BigInteger.valueOf(map.mapValue().size()));
        }
        for (Map.Entry<CborObject, CborObject> entry : map.mapValue().entrySet()) {
            this.writeDataItem(entry.getKey());
            this.writeDataItem(entry.getValue());
        }
        if (map.isIndefiniteLength()) {
            this.mEncoderStream.put((byte)-1);
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborSimple obj) throws IOException {
        this.writeCborFullInteger(obj.getMajorType(), BigInteger.valueOf(obj.getValue()));
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborByteString obj) throws IOException {
        if (obj.isIndefiniteLength()) {
            byte[][] chunks;
            this.writeCborHeader(obj.getMajorType(), 31);
            for (byte[] chunk : chunks = obj.byteArrayValue()) {
                this.writeCborFullInteger(2, BigInteger.valueOf(chunk.length));
                this.mEncoderStream.put(chunk);
            }
            this.mEncoderStream.put((byte)-1);
        } else {
            this.writeCborFullInteger(obj.getMajorType(), BigInteger.valueOf(BigArrays.length((byte[][])obj.byteArrayValue())));
            this.mEncoderStream.put(obj.byteArrayValue());
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborTextString obj) throws IOException {
        if (obj.isIndefiniteLength()) {
            byte[][] chunks;
            this.writeCborHeader(obj.getMajorType(), 31);
            for (byte[] chunk : chunks = obj.byteArrayValue()) {
                this.writeCborFullInteger(3, BigInteger.valueOf(chunk.length));
                this.mEncoderStream.put(chunk);
            }
            this.mEncoderStream.put((byte)-1);
        } else {
            this.writeCborFullInteger(obj.getMajorType(), BigInteger.valueOf(obj.byteArrayValue()[0].length));
            this.mEncoderStream.put(obj.byteArrayValue());
        }
        return this;
    }
}

